/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.api.jei;

import com.phylogeny.extrabitmanipulation.api.jei.Translator;
import com.phylogeny.extrabitmanipulation.api.jei.armor.ChiseledArmorInfoRecipe;
import com.phylogeny.extrabitmanipulation.api.jei.armor.ChiseledArmorInfoRecipeCategory;
import com.phylogeny.extrabitmanipulation.api.jei.armor.ChiseledArmorInfoRecipeHandler;
import com.phylogeny.extrabitmanipulation.api.jei.model.ModelInfoRecipe;
import com.phylogeny.extrabitmanipulation.api.jei.model.ModelInfoRecipeCategory;
import com.phylogeny.extrabitmanipulation.api.jei.model.ModelInfoRecipeHandler;
import com.phylogeny.extrabitmanipulation.api.jei.shape.ShapeInfoRecipe;
import com.phylogeny.extrabitmanipulation.api.jei.shape.ShapeInfoRecipeCategory;
import com.phylogeny.extrabitmanipulation.api.jei.shape.ShapeInfoRecipeHandler;
import com.phylogeny.extrabitmanipulation.init.BlocksExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.ItemsExtraBitManipulation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JustEnoughItemsPlugin
extends BlankModPlugin {
    private static IJeiRuntime jeiRuntime;

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JustEnoughItemsPlugin.jeiRuntime = jeiRuntime;
    }

    public static void openCategory(String categoryUid) {
        jeiRuntime.getRecipesGui().showCategories(Collections.singletonList(categoryUid));
    }

    public static String translate(String langKey) {
        return Translator.translateToLocal("jei.extrabitmanipulation." + langKey);
    }

    public void register(IModRegistry registry) {
        this.addDescription(registry, "bit_wrench", ItemsExtraBitManipulation.bitWrench);
        List<ItemStack> modelingStacks = this.addDescription(registry, "modeling_tool", ItemsExtraBitManipulation.modelingTool);
        List<ItemStack> sculptingStacks = this.addDescription(registry, "sculpting", ItemsExtraBitManipulation.sculptingLoop, ItemsExtraBitManipulation.sculptingSquare, ItemsExtraBitManipulation.sculptingSpadeCurved, ItemsExtraBitManipulation.sculptingSpadeSquared);
        ModItems items = ChiselsAndBits.getItems();
        this.addDescription(registry, "block_bit", new Item[]{items.itemBlockBit});
        this.addDescription(registry, "designs", new Item[]{items.itemMirrorprint, items.itemNegativeprint, items.itemPositiveprint});
        List<ItemStack> armorStacks = this.addDescription(registry, "chiseled_armor", ItemsExtraBitManipulation.chiseledHelmet, ItemsExtraBitManipulation.chiseledChestplate, ItemsExtraBitManipulation.chiseledLeggings, ItemsExtraBitManipulation.chiseledBoots);
        Item templateItem = Item.func_150898_a((Block)BlocksExtraBitManipulation.bodyPartTemplate);
        this.addDescription(registry, templateItem);
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        this.registerCatagoryAndRecipes(registry, (IRecipeCategory)new ShapeInfoRecipeCategory(guiHelper), new ShapeInfoRecipeHandler(), ShapeInfoRecipe.create(sculptingStacks));
        this.registerCatagoryAndRecipes(registry, (IRecipeCategory)new ModelInfoRecipeCategory(guiHelper), new ModelInfoRecipeHandler(), ModelInfoRecipe.create(modelingStacks));
        ArrayList<ItemStack> iconStacks = new ArrayList<ItemStack>();
        iconStacks.addAll(armorStacks);
        iconStacks.add(new ItemStack(templateItem));
        this.registerCatagoryAndRecipes(registry, (IRecipeCategory)new ChiseledArmorInfoRecipeCategory(guiHelper), new ChiseledArmorInfoRecipeHandler(), ChiseledArmorInfoRecipe.create(iconStacks));
        for (ItemStack sculptingStack : sculptingStacks) {
            registry.addRecipeCategoryCraftingItem(sculptingStack, new String[]{"extrabitmanipulationshape"});
        }
        registry.addRecipeCategoryCraftingItem(modelingStacks.get(0), new String[]{"extrabitmanipulationmodel"});
        for (ItemStack armorStack : armorStacks) {
            registry.addRecipeCategoryCraftingItem(armorStack, new String[]{"extrabitmanipulationchiseled_armor"});
        }
    }

    private void registerCatagoryAndRecipes(IModRegistry registry, IRecipeCategory category, IRecipeHandler handler, List recipes) {
        registry.addRecipeCategories(new IRecipeCategory[]{category});
        registry.addRecipeHandlers(new IRecipeHandler[]{handler});
        registry.addRecipes(recipes);
    }

    private ItemStack addDescription(IModRegistry registry, Item item) {
        ItemStack stack = new ItemStack(item, 1, Short.MAX_VALUE);
        registry.addDescription(stack, new String[]{"jei.description." + item.getRegistryName()});
        return stack;
    }

    private List<ItemStack> addDescription(IModRegistry registry, String langKeySuffix, Item ... items) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : items) {
            stacks.add(new ItemStack(item, 1, Short.MAX_VALUE));
        }
        registry.addDescription(stacks, new String[]{"jei.description.extrabitmanipulation:" + langKeySuffix});
        return stacks;
    }
}

