/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.api.jei;

import com.phylogeny.extrabitmanipulation.api.jei.JustEnoughItemsPlugin;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class InfoRecipeBase
extends BlankRecipeWrapper {
    protected List<ItemStack> itemStacks;
    protected List<String> tooltipLines = new ArrayList<String>();
    protected ResourceLocation image;
    protected int imageWidth;
    protected int imageHeight;
    protected String name;
    protected String text;
    protected Rectangle imageBox;

    public InfoRecipeBase(List<ItemStack> itemStacks, int imageWidth, int imageHeight, String recipeName, String imageName, String tooltipName, int imageLeft, int imageTop, int imageRight, int imageBottom, String catagoryName) {
        this.itemStacks = itemStacks;
        this.image = new ResourceLocation("extrabitmanipulation", "textures/jei/images/" + imageName + ".png");
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.name = JustEnoughItemsPlugin.translate(catagoryName + ".name." + recipeName);
        String toolTip = ".tooltip";
        if (!tooltipName.contains(".")) {
            tooltipName = tooltipName + ".";
        } else {
            toolTip = toolTip + ".";
        }
        tooltipName = tooltipName.replaceFirst("[.]", toolTip);
        this.tooltipLines.addAll(Arrays.asList(JustEnoughItemsPlugin.translate(tooltipName).split("\\\\n")));
        this.text = JustEnoughItemsPlugin.translate(tooltipName.replace("tooltip", "text"));
        this.imageBox = new Rectangle(imageLeft, imageTop, imageRight - imageLeft, imageBottom - imageTop);
    }

    public List<ItemStack> getInputs() {
        return this.itemStacks;
    }

    public List<ItemStack> getOutputs() {
        return this.itemStacks;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> getTooltips = new ArrayList<String>();
        if (this.imageBox.contains(mouseX, mouseY)) {
            getTooltips.addAll(this.tooltipLines);
        }
        return getTooltips;
    }

    protected String translateName(String catagoryName, String name) {
        return JustEnoughItemsPlugin.translate(catagoryName + ".name." + name);
    }
}

