/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.integration;

import com.feed_the_beast.ftbl.api.events.ClientGuideEvent;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.DrawableItem;
import com.feed_the_beast.ftbl.lib.client.DrawableObjectList;
import com.feed_the_beast.ftbl.lib.guide.DrawableObjectListLine;
import com.feed_the_beast.ftbl.lib.guide.GuideContentsLine;
import com.feed_the_beast.ftbl.lib.guide.GuideExtendedTextLine;
import com.feed_the_beast.ftbl.lib.guide.GuideHrLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.guide.GuideTitlePage;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class TiCIntegration {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuideEvent(ClientGuideEvent event) {
        GuideTitlePage guide = event.getModGuide("tconstruct");
        guide.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Item.func_111206_d((String)"tconstruct:toolforge"), 1, 0)));
        guide.println((Object)new GuideHrLine(1, Color4I.NONE));
        guide.println((Object)new GuideContentsLine((GuidePage)guide));
        GuidePage pageIntro = TiCIntegration.loadPage(event, "intro");
        if (pageIntro != null) {
            pageIntro.setTitle((ITextComponent)new TextComponentString("Introduction"));
            pageIntro.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Item.func_111206_d((String)"tconstruct:tooltables"), 1, 0)));
            guide.addSub(pageIntro);
        }
        GuidePage toolMaterials = guide.getSub("materials");
        toolMaterials.setTitle((ITextComponent)new TextComponentString("Materials"));
        toolMaterials.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Items.field_151035_b)));
        ImmutableList mats = ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.cobalt, (Object)TinkerMaterials.ardite, (Object)TinkerMaterials.manyullyn);
        for (Object material : TinkerRegistry.getAllMaterials()) {
            if (material.isHidden() || !material.hasItems()) continue;
            GuidePage page = toolMaterials.getSub(material.getIdentifier());
            page.setIcon((IDrawableObject)new DrawableItem(material.getRepresentativeItem()));
            page.setTitle((ITextComponent)new TextComponentString(material.getLocalizedName()));
            for (IMaterialStats stats : material.getAllStats()) {
                TextComponentString component = new TextComponentString(stats.getLocalizedName());
                component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                page.println((Object)component);
                DrawableObjectList parts = new DrawableObjectList(Collections.emptyList());
                for (IToolPart part : TinkerRegistry.getToolParts()) {
                    if (!part.hasUseForStat(stats.getIdentifier())) continue;
                    parts.list.add(new DrawableItem(part.getItemstackWithMaterial((Material)material)));
                }
                if (parts.list.size() > 0) {
                    page.println((Object)new DrawableObjectListLine(parts, 8));
                }
                for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
                    TextComponentString component1 = new TextComponentString(TiCIntegration.transformString((String)stats.getLocalizedInfo().get(i)));
                    component1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(TiCIntegration.transformString((String)stats.getLocalizedDesc().get(i)))));
                    page.println((Object)new GuideExtendedTextLine((ITextComponent)component1));
                }
                page.println(null);
            }
        }
        GuidePage modifiers = guide.getSub("modifiers");
        modifiers.setTitle((ITextComponent)new TextComponentString("Modifiers"));
        modifiers.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Items.field_151137_ax)));
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            if (modifier.isHidden() || !modifier.hasItemsToApplyWith()) continue;
            try {
                IResource resource = event.getResourceManager().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/modifiers/" + modifier.getIdentifier() + ".json"));
                JsonElement json = JsonUtils.fromJson((Reader)new InputStreamReader(resource.func_110527_b()));
                if (!json.isJsonObject()) continue;
                JsonObject o = json.getAsJsonObject();
                GuidePage page = modifiers.getSub(modifier.getIdentifier());
                page.setTitle((ITextComponent)new TextComponentString(modifier.getLocalizedName()));
                page.println((Object)TiCIntegration.transformString(modifier.getLocalizedDesc()));
                DrawableObjectList displayItems = new DrawableObjectList(Collections.emptyList());
                if (o.has("text")) {
                    page.println(null);
                    for (JsonElement e : o.get("text").getAsJsonArray()) {
                        page.println((Object)JsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (o.has("effects")) {
                    page.println(null);
                    page.println((Object)"Effects:");
                    for (JsonElement e : o.get("effects").getAsJsonArray()) {
                        page.println((Object)JsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (!o.has("demoTool")) continue;
                for (JsonElement e : o.get("demoTool").getAsJsonArray()) {
                    Item item = Item.func_111206_d((String)e.getAsString());
                    if (!(item instanceof ToolCore)) continue;
                    displayItems.list.add(new DrawableItem(((ToolCore)item).buildItemForRendering((List)mats.subList(0, ((ToolCore)item).getRequiredComponents().size()))));
                }
                if (displayItems.list.isEmpty()) continue;
                page.println(null);
                page.println((Object)new DrawableObjectListLine(displayItems, 8));
            }
            catch (Exception exception) {}
        }
        modifiers.sort(false);
        GuidePage pageSmeltry = TiCIntegration.loadPage(event, "smeltery");
        if (pageSmeltry != null) {
            pageSmeltry.setTitle((ITextComponent)new TextComponentString("Smeltry"));
            pageSmeltry.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Item.func_111206_d((String)"tconstruct:toolstation"), 1, 0)));
            guide.addSub(pageSmeltry);
        }
    }

    private static String transformString(String s) {
        return StringUtils.trimAllWhitespace((String)s.replace("\\n", "\n"));
    }

    @Nullable
    private static GuidePage loadPage(ClientGuideEvent event, String id) {
        try {
            IResource resource = event.getResourceManager().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/sections/" + id + ".json"));
            JsonElement json = JsonUtils.fromJson((Reader)new InputStreamReader(resource.func_110527_b()));
            if (json.isJsonArray()) {
                GuidePage page = new GuidePage(id);
                for (JsonElement jsonElement : json.getAsJsonArray()) {
                }
                return page;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

