/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import java.util.List;
import net.darkhax.bookshelf.lib.util.MathsUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public final class EntityUtils {
    private static final EntityEquipmentSlot[] EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    private EntityUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static double getDistanceFromEntity(Entity firstEntity, Entity secondEntity) {
        return MathsUtils.getDistanceBetweenPoints(firstEntity.func_174791_d(), secondEntity.func_174791_d());
    }

    public static double getDistaceFromPos(Entity entity, BlockPos pos) {
        return MathsUtils.getDistanceBetweenPoints(entity.func_174791_d(), new Vec3d((Vec3i)pos));
    }

    public static void pushTowards(Entity entityToMove, EnumFacing direction, double force) {
        EntityUtils.pushTowards(entityToMove, entityToMove.func_180425_c().func_177967_a(direction.func_176734_d(), 1), force);
    }

    public static void pushTowards(Entity entityToMove, BlockPos pos, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_180425_c();
        double distanceX = (double)pos.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)pos.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
        }
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceX = destination.field_70165_t - entityToMove.field_70165_t;
        double distanceY = destination.field_70163_u - entityToMove.field_70163_u;
        double distanceZ = destination.field_70161_v - entityToMove.field_70161_v;
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
        }
    }

    public static Vec3d pushTowardsDirection(Entity entityToMove, EnumFacing direction, double force) {
        Vec3d vec3d;
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_180425_c();
        BlockPos destination = entityToMove.func_180425_c().func_177967_a(direction.func_176734_d(), 1);
        double distanceX = (double)destination.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)destination.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
            Vec3d vec3d2 = new Vec3d(entityToMove.field_70159_w, entityToMove.field_70181_x, entityToMove.field_70179_y);
            vec3d = vec3d2;
        } else {
            vec3d = new Vec3d(0.0, 0.0, 0.0);
        }
        return vec3d;
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityUtils.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T> List<T> getEntitiesInArea(Class<? extends Entity> entityClass, World world, BlockPos pos, int range) {
        return world.func_72872_a(entityClass, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
    }

    public static EntityEquipmentSlot getEquipmentSlot(int index) {
        if (index >= 0 && index < EQUIPMENT_SLOTS.length) {
            return EQUIPMENT_SLOTS[index];
        }
        return null;
    }

    public static boolean isWearingFullSet(EntityLivingBase living, Class<Item> armorClass) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack armor;
            if (!slot.func_188453_a().equals((Object)EntityEquipmentSlot.Type.ARMOR) || (armor = living.func_184582_a(slot)) != null && armor.func_77973_b().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }
}

