/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.handler;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.darkhax.bookshelf.lib.util.TextUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public final class SupporterHandler {
    private static final ResourceLocation textureElytraMissing = new ResourceLocation("bookshelf", "textures/entity/player/missing_elytra.png");
    private static final List<SupporterData> supporterData = new ArrayList<SupporterData>();
    private static final String supporterLocation = "https://raw.githubusercontent.com/Darkhax-Minecraft/Bookshelf/master/supporters.json";

    private SupporterHandler() {
        throw new IllegalAccessError("Utility class");
    }

    public static void readSupporterData() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(supporterLocation).openConnection();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)connection.getContent()));
            reader.beginObject();
            while (reader.hasNext()) {
                reader.nextName();
                UUID playerID = null;
                String type = null;
                boolean confirmed = false;
                boolean wantsHead = true;
                boolean wantsWawla = false;
                String elytraTexture = null;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if ("playerID".equals(name)) {
                        playerID = UUID.fromString(reader.nextString());
                        continue;
                    }
                    if ("type".equals(name)) {
                        type = reader.nextString();
                        continue;
                    }
                    if ("confirmed".equals(name)) {
                        confirmed = reader.nextBoolean();
                        continue;
                    }
                    if ("wantHead".equals(name)) {
                        wantsHead = reader.nextBoolean();
                        continue;
                    }
                    if ("wantWawla".equals(name)) {
                        wantsWawla = reader.nextBoolean();
                        continue;
                    }
                    if ("elytraTexture".equals(name)) {
                        elytraTexture = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                supporterData.add(new SupporterData(playerID, type, confirmed, wantsHead, wantsWawla, elytraTexture));
                reader.endObject();
            }
            reader.endObject();
            reader.close();
        }
        catch (MalformedURLException e) {
            Constants.LOG.error("Could not access supporter data.", (Throwable)e);
        }
        catch (IOException e) {
            Constants.LOG.error("Could not access supporter data.", (Throwable)e);
        }
    }

    public static boolean isSupporter(EntityPlayer player) {
        for (SupporterData supporter : supporterData) {
            if (!supporter.getPlayerID().equals(player.func_110124_au())) continue;
            return true;
        }
        return false;
    }

    public static SupporterData getSupporterData(EntityPlayer player) {
        for (SupporterData supporter : supporterData) {
            if (!supporter.getPlayerID().equals(player.func_110124_au())) continue;
            return supporter;
        }
        return null;
    }

    public static SupporterData[] getSupporters() {
        return supporterData.toArray(new SupporterData[supporterData.size()]);
    }

    public static class SupporterData {
        private final UUID playerId;
        private final String type;
        private final boolean confirmed;
        private final boolean wantsHead;
        private final boolean wantsWawla;
        private final String ELYTRA_TEXTURE;

        protected SupporterData(UUID playerID, String type, boolean confirmed, boolean wantsHead, boolean wantsWawla, String elytraTexture) {
            this.playerId = playerID;
            this.type = type;
            this.confirmed = confirmed;
            this.wantsHead = wantsHead;
            this.wantsWawla = wantsWawla;
            this.ELYTRA_TEXTURE = elytraTexture;
        }

        public UUID getPlayerID() {
            return this.playerId;
        }

        public boolean isConfirmed() {
            return this.confirmed;
        }

        public boolean wantsHead() {
            return this.wantsHead;
        }

        public boolean wantsWawla() {
            return this.wantsWawla;
        }

        public String getElytraTextureURL() {
            return this.ELYTRA_TEXTURE;
        }

        public ResourceLocation getElytraTexture() {
            return this.ELYTRA_TEXTURE != null && !this.ELYTRA_TEXTURE.isEmpty() ? RenderUtils.downloadResourceLocation(this.ELYTRA_TEXTURE, new ResourceLocation("bookshelf", "elytra/" + this.getPlayerID().toString()), textureElytraMissing, null) : null;
        }

        public String getType() {
            return this.type;
        }

        public String getLocalizedType() {
            return this.type.toLowerCase();
        }

        public TextUtils.ChatFormat getFormat() {
            return "developer".equals(this.type) ? TextUtils.ChatFormat.GREEN : ("patreon".equals(this.type) ? TextUtils.ChatFormat.GOLD : ("contributor".equals(this.type) ? TextUtils.ChatFormat.AQUA : ("translator".equals(this.type) ? TextUtils.ChatFormat.RED : TextUtils.ChatFormat.RESET)));
        }
    }
}

