/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.render.item;

import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.darkhax.bookshelf.client.render.item.IGlTransformer;
import net.darkhax.bookshelf.client.render.item.IItemRenderer;
import net.darkhax.bookshelf.client.render.item.IStackPerspectiveAwareModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class RenderItemWrapper
extends RenderItem {
    private final RenderItem parent;
    private static boolean initialized;
    private static final Matrix4f flipX;

    private RenderItemWrapper(RenderItem parentRenderer) {
        super(parentRenderer.field_175057_n, parentRenderer.field_175059_m.func_178083_a(), parentRenderer.field_184395_f);
        this.field_175059_m = parentRenderer.field_175059_m;
        this.parent = parentRenderer;
    }

    public static RenderItem instance() {
        if (!initialized) {
            Minecraft.func_71410_x().field_175621_X = new RenderItemWrapper(Minecraft.func_71410_x().func_175599_af());
            initialized = true;
        }
        return Minecraft.func_71410_x().func_175599_af();
    }

    private IBakedModel handleTransforms(ItemStack stack, IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean isLeftHand) {
        IBakedModel transformedModel = model;
        if (transformedModel instanceof IGlTransformer) {
            ((IGlTransformer)transformedModel).applyTransforms(transformType, isLeftHand);
        } else if (transformedModel instanceof IPerspectiveAwareModel) {
            transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)transformedModel, (ItemCameraTransforms.TransformType)transformType, (boolean)isLeftHand);
        } else if (transformedModel instanceof IStackPerspectiveAwareModel) {
            Pair<? extends IBakedModel, Matrix4f> pair = ((IStackPerspectiveAwareModel)transformedModel).handlePerspective(stack, transformType);
            if (pair.getRight() != null) {
                Matrix4f matrix = new Matrix4f((Matrix4f)pair.getRight());
                if (isLeftHand) {
                    matrix.mul(flipX, matrix);
                    matrix.mul(matrix, flipX);
                }
                ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)matrix);
            }
            return (IBakedModel)pair.getLeft();
        }
        return transformedModel;
    }

    private boolean isExtendedModel(IBakedModel model) {
        return model instanceof IItemRenderer || model instanceof IGlTransformer || model instanceof IStackPerspectiveAwareModel;
    }

    public void func_180454_a(ItemStack stack, IBakedModel model) {
        if (stack != null && model instanceof IItemRenderer) {
            IItemRenderer renderer = (IItemRenderer)model;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            renderer.renderItem(stack);
            GlStateManager.func_179121_F();
            return;
        }
        this.parent.func_180454_a(stack, model);
    }

    public void func_184394_a(ItemStack stack, IBakedModel bakedModel, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (stack.func_77973_b() != null) {
            if (this.isExtendedModel(bakedModel)) {
                this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
                this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                IBakedModel transformedModel = this.handleTransforms(stack, bakedModel, transform, leftHanded);
                this.func_180454_a(stack, transformedModel);
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                GlStateManager.func_179121_F();
                GlStateManager.func_179101_C();
                GlStateManager.func_179084_k();
                this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
                this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174935_a();
            } else {
                this.parent.field_77023_b = this.field_77023_b;
                this.parent.func_184394_a(stack, bakedModel, transform, leftHanded);
            }
        }
    }

    public void func_184390_a(ItemStack stack, int x, int y, IBakedModel bakedModel) {
        if (this.isExtendedModel(bakedModel)) {
            GlStateManager.func_179094_E();
            this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
            this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_180452_a(x, y, bakedModel.func_177556_c());
            IBakedModel transformedModel = this.handleTransforms(stack, bakedModel, ItemCameraTransforms.TransformType.GUI, false);
            this.func_180454_a(stack, transformedModel);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
            this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        } else {
            this.parent.field_77023_b = this.field_77023_b;
            this.parent.func_184390_a(stack, x, y, bakedModel);
        }
    }

    public void func_181564_a(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        if (stack != null) {
            IBakedModel bakedModel = this.func_184393_a(stack, null, null);
            if (this.isExtendedModel(bakedModel)) {
                this.func_184394_a(stack, bakedModel, cameraTransformType, false);
            }
            this.parent.field_77023_b = this.field_77023_b;
            this.parent.func_181564_a(stack, cameraTransformType);
        }
    }

    public void func_184392_a(ItemStack stack, EntityLivingBase livingBase, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (stack != null && livingBase != null && stack.func_77973_b() != null) {
            IBakedModel bakedModel = this.func_184393_a(stack, livingBase.field_70170_p, livingBase);
            if (this.isExtendedModel(bakedModel)) {
                this.func_184394_a(stack, bakedModel, transform, leftHanded);
            } else {
                this.parent.field_77023_b = this.field_77023_b;
                this.parent.func_184392_a(stack, livingBase, transform, leftHanded);
            }
        }
    }

    public void func_175042_a(ItemStack stack, int x, int y) {
        IBakedModel bakedModel = this.func_184393_a(stack, null, null);
        if (this.isExtendedModel(bakedModel)) {
            this.func_184390_a(stack, x, y, bakedModel);
        } else {
            this.parent.field_77023_b = this.field_77023_b;
            this.parent.func_175042_a(stack, x, y);
        }
    }

    public void func_180450_b(ItemStack stack, int xPosition, int yPosition) {
        this.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void func_184391_a(@Nullable EntityLivingBase livingBase, ItemStack stack, int x, int y) {
        if (stack != null && stack.func_77973_b() != null) {
            try {
                IBakedModel model = this.func_184393_a(stack, null, livingBase);
                if (this.isExtendedModel(model)) {
                    this.field_77023_b += 50.0f;
                    this.func_184390_a(stack, x, y, model);
                    this.field_77023_b -= 50.0f;
                } else {
                    this.parent.field_77023_b = this.field_77023_b;
                    this.parent.func_184391_a(livingBase, stack, x, y);
                }
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", () -> String.valueOf(stack.func_77973_b()));
                crashreportcategory.func_189529_a("Item Aux", () -> String.valueOf(stack.func_77960_j()));
                crashreportcategory.func_189529_a("Item NBT", () -> String.valueOf(stack.func_77978_p()));
                crashreportcategory.func_189529_a("Item Foil", () -> String.valueOf(stack.func_77962_s()));
                throw new ReportedException(crashreport);
            }
        }
    }

    public void func_175041_b() {
    }

    public void func_175048_a(Item item, int subType, String identifier) {
        this.parent.func_175048_a(item, subType, identifier);
    }

    public void func_175039_a(boolean isNot) {
        this.parent.func_175039_a(isNot);
    }

    public ItemModelMesher func_175037_a() {
        return this.parent.func_175037_a();
    }

    public boolean func_175050_a(ItemStack stack) {
        return this.parent.func_175050_a(stack);
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entitylivingbaseIn) {
        return this.parent.func_184393_a(stack, worldIn, entitylivingbaseIn);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.parent.func_110549_a(resourceManager);
    }

    static {
        flipX = new Matrix4f();
        flipX.setIdentity();
        RenderItemWrapper.flipX.m00 = -1.0f;
    }
}

