/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm;

import net.darkhax.bookshelf.asm.ASMUtils;
import net.darkhax.bookshelf.lib.Constants;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Mapping {
    private final String name;
    private final String classPath;
    private final String descriptor;

    public Mapping(String srgName, String mcpName, String path, String descriptor) {
        this.name = ASMUtils.isSrg ? srgName : mcpName;
        this.descriptor = descriptor;
        this.classPath = path;
    }

    public Mapping(String name, String path, String descriptor) {
        this.name = name;
        this.descriptor = descriptor;
        this.classPath = path;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public MethodNode getMethodNode(ClassNode classNode) {
        for (MethodNode mnode : classNode.methods) {
            if (!this.getName().equals(mnode.name) || !this.descriptor.equals(mnode.desc)) continue;
            return mnode;
        }
        Constants.LOG.warn((Object)new RuntimeException(String.format("The method %s with descriptor %s could not be found in %s", this.getName(), this.descriptor, classNode.name)));
        return null;
    }

    public MethodInsnNode getMethodInsn(int opcode, boolean isInterface) {
        return new MethodInsnNode(opcode, this.classPath, this.name, this.descriptor, isInterface);
    }

    public FieldInsnNode getFieldNode(int opCode) {
        return new FieldInsnNode(opCode, this.classPath, this.getName(), this.getDescriptor());
    }
}

