/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.jsonDestroyer.client;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import me.modmuss50.jsonDestroyer.JsonDestroyer;
import me.modmuss50.jsonDestroyer.api.IDestroyable;
import me.modmuss50.jsonDestroyer.api.IHandHeld;
import me.modmuss50.jsonDestroyer.api.IOpaqueBlock;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import me.modmuss50.jsonDestroyer.api.ITexturedBucket;
import me.modmuss50.jsonDestroyer.api.ITexturedFluid;
import me.modmuss50.jsonDestroyer.api.ITexturedItem;
import me.modmuss50.jsonDestroyer.client.ModelHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ModelGenerator {
    private FaceBakery faceBakery = new FaceBakery();
    private JsonDestroyer jsonDestroyer;
    public ArrayList<BlockIconInfo> blockIconInfoList = new ArrayList();
    public HashMap<BlockIconInfo, TextureAtlasSprite> blockIconList = new HashMap();
    public HashMap<Fluid, TextureAtlasSprite> fluidIcons = new HashMap();
    public List<ItemIconInfo> itemIcons = new ArrayList<ItemIconInfo>();

    public ModelGenerator(JsonDestroyer jsonDestroyer) {
        this.jsonDestroyer = jsonDestroyer;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.blockIconInfoList.clear();
        this.fluidIcons.clear();
        this.itemIcons.clear();
        TextureMap textureMap = event.getMap();
        for (Object object : this.jsonDestroyer.objectsToDestroy) {
            IDestroyable itemTexture;
            int i;
            if (object instanceof Block && object instanceof ITexturedBlock) {
                ITexturedBlock blockTextureProvider = (ITexturedBlock)object;
                Block block = (Block)object;
                for (i = 0; i < blockTextureProvider.amountOfStates(); ++i) {
                    for (EnumFacing side : EnumFacing.values()) {
                        String name = blockTextureProvider.getTextureNameFromState(block.func_176203_a(i), side);
                        TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                        if (texture == null) {
                            texture = new CustomTexture(name);
                            textureMap.setTextureEntry(name, texture);
                        }
                        BlockIconInfo iconInfo = new BlockIconInfo(block, i, side);
                        this.blockIconList.put(iconInfo, texture);
                        this.blockIconInfoList.add(iconInfo);
                    }
                }
                continue;
            }
            if (object instanceof BlockFluidBase && object instanceof ITexturedFluid) {
                BlockFluidBase blockFluidBase = (BlockFluidBase)object;
                String name = blockFluidBase.getFluid().getFlowing().toString();
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new CustomTexture(name);
                    textureMap.setTextureEntry(name, texture);
                }
                this.fluidIcons.put(blockFluidBase.getFluid(), texture);
                continue;
            }
            if (object instanceof Item && object instanceof ITexturedItem) {
                itemTexture = (ITexturedItem)object;
                Item item = (Item)object;
                for (i = 0; i < itemTexture.getMaxMeta(); ++i) {
                    String name = itemTexture.getTextureName(i);
                    TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                    if (texture == null) {
                        texture = new CustomTexture(name);
                        textureMap.setTextureEntry(name, texture);
                    }
                    ItemIconInfo info = new ItemIconInfo((Item)object, i, texture, name);
                    this.itemIcons.add(info);
                }
                continue;
            }
            if (!(object instanceof Item) || !(object instanceof ITexturedBucket)) continue;
            itemTexture = (ITexturedBucket)object;
            for (int i2 = 0; i2 < itemTexture.getMaxMeta(); ++i2) {
                String name = itemTexture.getFluid(i2).getStill().toString();
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new CustomTexture(name);
                    textureMap.setTextureEntry(name, texture);
                }
                ItemIconInfo info = new ItemIconInfo((Item)object, i2, texture, name);
                info.isBucket = true;
                this.itemIcons.add(info);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void bakeModels(ModelBakeEvent event) {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        block4: for (Object object : this.jsonDestroyer.objectsToDestroy) {
            Item item;
            Function textureGetter;
            BlockModel model;
            int i;
            if (object instanceof Block && object instanceof ITexturedBlock) {
                ITexturedBlock textureProvdier = (ITexturedBlock)object;
                Block block = (Block)object;
                for (i = 0; i < textureProvdier.amountOfStates(); ++i) {
                    HashMap<EnumFacing, TextureAtlasSprite> textureMap = new HashMap<EnumFacing, TextureAtlasSprite>();
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        for (BlockIconInfo iconInfo : this.blockIconInfoList) {
                            if (iconInfo.getBlock() != block || iconInfo.getMeta() != i || iconInfo.getSide() != side || !this.blockIconList.containsKey(iconInfo)) continue;
                            textureMap.put(side, this.blockIconList.get(iconInfo));
                        }
                    }
                    if (textureMap.isEmpty()) {
                        return;
                    }
                    ItemCameraTransforms transforms = null;
                    try {
                        transforms = ModelHelper.loadTransformFromJson(new ResourceLocation("minecraft:models/block/block"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((ItemCameraTransforms)transforms);
                    model = new BlockModel(textureMap, block.func_176203_a(i).func_177230_c() instanceof IOpaqueBlock, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map);
                    ModelResourceLocation modelResourceLocation = ModelGenerator.getModelResourceLocation(block.func_176203_a(i));
                    event.getModelRegistry().func_82595_a((Object)modelResourceLocation, (Object)model);
                    ModelResourceLocation inventory = ModelGenerator.getBlockInventoryResourceLocation(block);
                    event.getModelRegistry().func_82595_a((Object)inventory, (Object)model);
                    itemModelMesher.func_178086_a(Item.func_150898_a((Block)block), i, inventory);
                    event.getModelRegistry().func_82595_a((Object)modelResourceLocation, (Object)model);
                    itemModelMesher.func_178086_a(Item.func_150898_a((Block)block), i, modelResourceLocation);
                }
                continue;
            }
            if (object instanceof ITexturedFluid && object instanceof BlockFluidBase) {
                BlockFluidBase blockFluidBase = (BlockFluidBase)object;
                Fluid fluid = blockFluidBase.getFluid();
                ModelResourceLocation fluidLocation = new ModelResourceLocation(fluid.getFlowing(), "fluid");
                Item fluidItem = Item.func_150898_a((Block)blockFluidBase);
                ModelBakery.registerItemVariants((Item)fluidItem, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)fluidItem, stack -> fluidLocation);
                for (int i2 = 0; i2 < 16; ++i2) {
                    ModelResourceLocation location2 = new ModelResourceLocation(ModelGenerator.getBlockResourceLocation((Block)blockFluidBase), "level=" + i2);
                    ModelFluid modelFluid = new ModelFluid(fluid);
                    textureGetter = location1 -> this.fluidIcons.get(fluid);
                    IBakedModel bakedModel = modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176600_a, textureGetter);
                    event.getModelRegistry().func_82595_a((Object)location2, (Object)bakedModel);
                }
                ModelResourceLocation inventoryLocation = new ModelResourceLocation(ModelGenerator.getBlockResourceLocation((Block)blockFluidBase), "inventory");
                ModelFluid modelFluid = new ModelFluid(fluid);
                Function textureGetter2 = location -> this.fluidIcons.get(fluid);
                IBakedModel bakedModel = modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter2);
                event.getModelRegistry().func_82595_a((Object)inventoryLocation, (Object)bakedModel);
                continue;
            }
            if (object instanceof Item && object instanceof ITexturedItem) {
                ITexturedItem iTexturedItem = (ITexturedItem)object;
                item = (Item)object;
                for (i = 0; i < iTexturedItem.getMaxMeta(); ++i) {
                    TextureAtlasSprite texture = null;
                    ItemIconInfo itemIconInfo = null;
                    for (ItemIconInfo info : this.itemIcons) {
                        if (info.damage != i || info.getItem() != item || info.isBucket) continue;
                        texture = info.getSprite();
                        itemIconInfo = info;
                        break;
                    }
                    if (texture == null) continue block4;
                    ModelResourceLocation inventory = ModelGenerator.getItemInventoryResourceLocation(item);
                    if (iTexturedItem.getMaxMeta() != 1 && iTexturedItem.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0) != null) {
                        inventory = iTexturedItem.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
                        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{inventory});
                    }
                    TextureAtlasSprite finalTexture = texture;
                    textureGetter = location -> finalTexture;
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.add((Object)new ResourceLocation(itemIconInfo.textureName));
                    ItemLayerModel itemLayerModel = new ItemLayerModel(builder.build());
                    IBakedModel model2 = itemLayerModel.bake(ItemLayerModel.INSTANCE.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
                    ItemCameraTransforms transforms = null;
                    try {
                        transforms = item instanceof IHandHeld ? ModelHelper.loadTransformFromJson(new ResourceLocation("minecraft:models/item/handheld")) : ModelHelper.loadTransformFromJson(new ResourceLocation("minecraft:models/item/generated"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms(transforms);
                    IPerspectiveAwareModel.MapWrapper iPerspectiveAwareModel = new IPerspectiveAwareModel.MapWrapper(model2, map);
                    itemModelMesher.func_178086_a(item, i, inventory);
                    event.getModelRegistry().func_82595_a((Object)inventory, (Object)iPerspectiveAwareModel);
                }
                continue;
            }
            if (!(object instanceof Item) || !(object instanceof ITexturedBucket)) continue;
            ITexturedBucket iTexturedBucket = (ITexturedBucket)object;
            item = (Item)object;
            for (i = 0; i < iTexturedBucket.getMaxMeta(); ++i) {
                ModelResourceLocation inventory = ModelGenerator.getItemInventoryResourceLocation(item);
                if (iTexturedBucket.getMaxMeta() != 1 && iTexturedBucket.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0) != null) {
                    inventory = iTexturedBucket.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
                }
                Function textureGetter3 = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                ModelDynBucket modelDynBucket = new ModelDynBucket(new ResourceLocation("forge:items/bucket_base"), new ResourceLocation("forge:items/bucket_fluid"), new ResourceLocation("forge:items/bucket_cover"), iTexturedBucket.getFluid(i), iTexturedBucket.isGas(i));
                model = modelDynBucket.bake(ItemLayerModel.INSTANCE.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter3);
                itemModelMesher.func_178086_a(item, i, inventory);
                event.getModelRegistry().func_82595_a((Object)inventory, (Object)model);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelResourceLocation(IBlockState state) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), new DefaultStateMapper().func_178131_a((Map)state.func_177228_b()));
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getBlockInventoryResourceLocation(Block block) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getItemInventoryResourceLocation(Item block) {
        return new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)block), "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getBlockResourceLocation(Block block) {
        return (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
    }

    public class ItemIconInfo {
        Item item;
        int damage;
        TextureAtlasSprite sprite;
        String textureName;
        public boolean isBucket = false;

        public Item getItem() {
            return this.item;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public ItemIconInfo(Item item, int damage, TextureAtlasSprite sprite, String textureName) {
            this.item = item;
            this.damage = damage;
            this.sprite = sprite;
            this.textureName = textureName;
        }
    }

    public class BlockModel
    implements IPerspectiveAwareModel {
        HashMap<EnumFacing, TextureAtlasSprite> textureAtlasSpriteHashMap;
        boolean isOpaque;
        ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public BlockModel(HashMap<EnumFacing, TextureAtlasSprite> textureAtlasSpriteHashMap, boolean isOpaque, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.textureAtlasSpriteHashMap = textureAtlasSpriteHashMap;
            this.isOpaque = isOpaque;
            this.transforms = transforms;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            BlockFaceUV uv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
            BlockPartFace face = new BlockPartFace(null, 0, "", uv);
            ModelRotation modelRot = ModelRotation.X0_Y0;
            boolean scale = true;
            if (this.isOpaque) {
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 0.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.DOWN), EnumFacing.DOWN, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 16.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.UP), EnumFacing.UP, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 0.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.NORTH), EnumFacing.NORTH, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.SOUTH), EnumFacing.SOUTH, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.EAST), EnumFacing.EAST, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.WEST), EnumFacing.WEST, modelRot, null, scale, true));
            }
            if (side == null || this.isOpaque) {
                return list;
            }
            if (!this.isOpaque) {
                switch (side) {
                    case DOWN: {
                        list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 0.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                        break;
                    }
                    case UP: {
                        list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 16.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                        break;
                    }
                    case NORTH: {
                        list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 0.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                        break;
                    }
                    case SOUTH: {
                        list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                        break;
                    }
                    case EAST: {
                        list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                        break;
                    }
                    case WEST: {
                        list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                    }
                }
            }
            return list;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureAtlasSpriteHashMap.get(EnumFacing.DOWN);
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
            return Pair.of((Object)this, (Object)pair.getRight());
        }
    }

    public class BlockIconInfo {
        public Block block;
        public int meta;
        public EnumFacing side;

        public BlockIconInfo(Block block, int meta, EnumFacing side) {
            this.block = block;
            this.meta = meta;
            this.side = side;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMeta() {
            return this.meta;
        }

        public EnumFacing getSide() {
            return this.side;
        }
    }

    public class CustomTexture
    extends TextureAtlasSprite {
        public CustomTexture(String spriteName) {
            super(spriteName);
        }
    }
}

