/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import micdoodle8.mods.miccore.ConfigManagerMicCore;
import micdoodle8.mods.miccore.MicdoodlePlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.miccore"})
public class MicdoodleTransformer
implements IClassTransformer {
    HashMap<String, ObfuscationEntry> nodemap = new HashMap();
    private boolean deobfuscated = true;
    private boolean optifinePresent;
    private boolean isServer;
    private boolean playerApiActive;
    private String mcVersion = (String)FMLInjectionData.data()[4];
    private String nameForgeHooksClient;
    private String namePlayerList;
    private String namePlayerController;
    private String nameEntityLiving;
    private String nameEntityItem;
    private String nameEntityRenderer;
    private String nameItemRenderer;
    private String nameGuiSleep;
    private String nameParticleManager;
    private String nameNetHandlerPlay;
    private String nameRenderGlobal;
    private String nameRenderManager;
    private String nameEntity;
    private String nameChunkGeneratorOverworld;
    private String nameChunk;
    private String nameEntityArrow;
    private String nameEntityGolem;
    private String nameWorld;
    private static final String KEY_CLASS_PLAYER_MP = "PlayerMP";
    private static final String KEY_CLASS_WORLD = "worldClass";
    private static final String KEY_PLAYER_LIST = "confManagerClass";
    private static final String KEY_CLASS_GAME_PROFILE = "gameProfileClass";
    private static final String KEY_CLASS_INTERACTION_MANAGER = "interactionManagerClass";
    private static final String KEY_CLASS_PLAYER_CONTROLLER = "playerControllerClass";
    private static final String KEY_CLASS_PLAYER_SP = "playerClient";
    private static final String KEY_CLASS_STAT_FILE_WRITER = "statFileWriterClass";
    private static final String KEY_CLASS_RECIPE_BOOK = "recipeBookClass";
    private static final String KEY_CLASS_NET_HANDLER_PLAY = "netHandlerPlayClientClass";
    private static final String KEY_CLASS_ENTITY_LIVING = "entityLivingClass";
    private static final String KEY_CLASS_ENTITY_ITEM = "entityItemClass";
    private static final String KEY_CLASS_ENTITY_RENDERER = "entityRendererClass";
    private static final String KEY_CLASS_RENDER_GLOBAL = "renderGlobalClass";
    private static final String KEY_CLASS_RENDER_MANAGER = "renderManagerClass";
    private static final String KEY_CLASS_TESSELLATOR = "tessellatorClass";
    private static final String KEY_CLASS_CONTAINER_PLAYER = "containerPlayer";
    private static final String KEY_CLASS_MINECRAFT = "minecraft";
    private static final String KEY_CLASS_SESSION = "session";
    private static final String KEY_CLASS_GUI_SCREEN = "guiScreen";
    private static final String KEY_CLASS_ITEM_RENDERER = "itemRendererClass";
    private static final String KEY_CLASS_VEC3 = "vecClass";
    private static final String KEY_CLASS_ENTITY = "entityClass";
    private static final String KEY_CLASS_TILEENTITY = "tileEntityClass";
    private static final String KEY_CLASS_GUI_SLEEP = "guiSleepClass";
    private static final String KEY_CLASS_PARTICLE_MANAGER = "effectRendererClass";
    private static final String KEY_CLASS_FORGE_HOOKS_CLIENT = "forgeHooks";
    private static final String KEY_CLASS_CUSTOM_PLAYER_MP = "customPlayerMP";
    private static final String KEY_CLASS_CUSTOM_PLAYER_SP = "customPlayerSP";
    private static final String KEY_CLASS_CUSTOM_OTHER_PLAYER = "customEntityOtherPlayer";
    private static final String KEY_CLASS_PACKET_SPAWN_PLAYER = "packetSpawnPlayer";
    private static final String KEY_CLASS_ENTITY_OTHER_PLAYER = "entityOtherPlayer";
    private static final String KEY_CLASS_SERVER = "minecraftServer";
    private static final String KEY_CLASS_WORLD_SERVER = "worldServer";
    private static final String KEY_CLASS_WORLD_CLIENT = "worldClient";
    private static final String KEY_CLASS_CHUNK_PROVIDER_OVERWORLD = "chunkProviderServer";
    private static final String KEY_CLASS_ICHUNKPROVIDER = "IChunkProvider";
    private static final String KEY_CLASS_ICHUNKGENERATOR = "IChunkGenerator";
    private static final String KEY_CLASS_CHUNK = "chunkClass";
    private static final String KEY_NET_HANDLER_LOGIN_SERVER = "netHandlerLoginServer";
    private static final String KEY_CLASS_ENTITY_ARROW = "entityArrow";
    private static final String KEY_CLASS_ENTITYGOLEM = "entityGolem";
    private static final String KEY_CLASS_IBLOCKACCESS = "iBlockAccess";
    private static final String KEY_CLASS_BLOCK = "blockClass";
    private static final String KEY_CLASS_BLOCKPOS = "blockPos";
    private static final String KEY_CLASS_IBLOCKSTATE = "blockState";
    private static final String KEY_CLASS_ICAMERA = "icameraClass";
    private static final String KEY_CLASS_INTCACHE = "intCache";
    private static final String KEY_FIELD_CHUNK_XPOS = "chunkXPos";
    private static final String KEY_FIELD_CHUNK_ZPOS = "chunkZPos";
    private static final String KEY_FIELD_CHUNK_WORLD = "world";
    private static final String KEY_METHOD_CREATE_PLAYER = "createPlayerMethod";
    private static final String KEY_METHOD_RESPAWN_PLAYER = "respawnPlayerMethod";
    private static final String KEY_METHOD_CREATE_CLIENT_PLAYER = "createClientPlayerMethod";
    private static final String KEY_METHOD_MOVE_ENTITY = "moveEntityMethod";
    private static final String KEY_METHOD_ON_UPDATE = "onUpdateMethod";
    private static final String KEY_METHOD_UPDATE_LIGHTMAP = "updateLightmapMethod";
    private static final String KEY_METHOD_RENDER_OVERLAYS = "renderOverlaysMethod";
    private static final String KEY_METHOD_UPDATE_FOG_COLOR = "updateFogColorMethod";
    private static final String KEY_METHOD_GET_FOG_COLOR = "getFogColorMethod";
    private static final String KEY_METHOD_GET_SKY_COLOR = "getSkyColorMethod";
    private static final String KEY_METHOD_WAKE_ENTITY = "wakeEntityMethod";
    private static final String KEY_METHOD_BED_ORIENT_CAMERA = "orientBedCamera";
    private static final String KEY_METHOD_RENDER_PARTICLES = "renderParticlesMethod";
    private static final String KEY_METHOD_CUSTOM_PLAYER_MP = "customPlayerMPConstructor";
    private static final String KEY_METHOD_CUSTOM_PLAYER_SP = "customPlayerSPConstructor";
    private static final String KEY_METHOD_HANDLE_SPAWN_PLAYER = "handleSpawnPlayerMethod";
    private static final String KEY_METHOD_ORIENT_CAMERA = "orientCamera";
    private static final String KEY_METHOD_CAN_RENDER_FIRE = "canRenderOnFire";
    private static final String KEY_METHOD_POPULATE_CHUNK = "populateChunk";
    private static final String KEY_METHOD_RENDER_MODEL = "renderModel";
    private static final String KEY_METHOD_RAIN_STRENGTH = "getRainStrength";
    private static final String KEY_METHOD_REGISTEROF = "registerOF";
    private static final String KEY_METHOD_SETUP_TERRAIN = "setupTerrain";
    private static final String KEY_METHOD_GET_EYE_HEIGHT = "getEyeHeight";
    private static final String KEY_METHOD_ENABLE_ALPHA = "enableAlphaMethod";
    private static final String KEY_METHOD_VALIDATE = "teValidate";
    private static final String CLASS_RUNTIME_INTERFACE = "micdoodle8/mods/miccore/Annotations$RuntimeInterface";
    private static final String CLASS_MICDOODLE_PLUGIN = "micdoodle8/mods/miccore/MicdoodlePlugin";
    private static final String CLASS_TRANSFORMER_HOOKS = "micdoodle8/mods/galacticraft/core/TransformerHooks";
    private static final String CLASS_INTCACHE_VARIANT = "micdoodle8/mods/miccore/IntCache";
    private static final String CLASS_GL11 = "org/lwjgl/opengl/GL11";
    private static final String CLASS_IENTITYBREATHABLE = "micdoodle8/mods/galacticraft/api/entity/IEntityBreathable";
    private static final String CLASS_SYNCMOD_CLONEPLAYER = "sync/common/tileentity/TileEntityDualVertical";
    private static final String CLASS_RENDERPLAYEROF = "RenderPlayerOF";
    private static final String CLASS_IFORGEARMOR = "net/minecraftforge/common/ISpecialArmor$ArmorProperties";
    private static int operationCount = 0;
    private static int injectionCount = 0;

    public MicdoodleTransformer() {
        try {
            this.deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
            this.optifinePresent = Launch.classLoader.getClassBytes("CustomColorizer") != null;
            this.playerApiActive = Launch.classLoader.getClassBytes("api.player.forge.PlayerAPITransformer") != null && !this.deobfuscated;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Launch.classLoader.addTransformerExclusion(CLASS_IENTITYBREATHABLE.replace('/', '.'));
        if (this.mcVersionMatches("[1.12.2]")) {
            this.nodemap.put(KEY_CLASS_PLAYER_MP, new ObfuscationEntry("net/minecraft/entity/player/EntityPlayerMP"));
            this.nodemap.put(KEY_CLASS_WORLD, new ObfuscationEntry("net/minecraft/world/World"));
            this.nodemap.put(KEY_PLAYER_LIST, new ObfuscationEntry("net/minecraft/server/management/PlayerList"));
            this.nodemap.put(KEY_CLASS_GAME_PROFILE, new ObfuscationEntry("com/mojang/authlib/GameProfile"));
            this.nodemap.put(KEY_CLASS_INTERACTION_MANAGER, new ObfuscationEntry("net/minecraft/server/management/PlayerInteractionManager"));
            this.nodemap.put(KEY_CLASS_PLAYER_CONTROLLER, new ObfuscationEntry("net/minecraft/client/multiplayer/PlayerControllerMP"));
            this.nodemap.put(KEY_CLASS_PLAYER_SP, new ObfuscationEntry("net/minecraft/client/entity/EntityPlayerSP"));
            this.nodemap.put(KEY_CLASS_STAT_FILE_WRITER, new ObfuscationEntry("net/minecraft/stats/StatisticsManager"));
            this.nodemap.put(KEY_CLASS_RECIPE_BOOK, new ObfuscationEntry("net/minecraft/stats/RecipeBook"));
            this.nodemap.put(KEY_CLASS_NET_HANDLER_PLAY, new ObfuscationEntry("net/minecraft/client/network/NetHandlerPlayClient"));
            this.nodemap.put(KEY_CLASS_ENTITY_LIVING, new ObfuscationEntry("net/minecraft/entity/EntityLivingBase"));
            this.nodemap.put(KEY_CLASS_ENTITY_ITEM, new ObfuscationEntry("net/minecraft/entity/item/EntityItem"));
            this.nodemap.put(KEY_CLASS_ENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/EntityRenderer"));
            this.nodemap.put(KEY_CLASS_RENDER_GLOBAL, new ObfuscationEntry("net/minecraft/client/renderer/RenderGlobal"));
            this.nodemap.put(KEY_CLASS_TESSELLATOR, new ObfuscationEntry("net/minecraft/client/renderer/Tessellator"));
            this.nodemap.put(KEY_CLASS_RENDER_MANAGER, new ObfuscationEntry("net/minecraft/client/renderer/entity/RenderManager"));
            this.nodemap.put(KEY_CLASS_CONTAINER_PLAYER, new ObfuscationEntry("net/minecraft/inventory/ContainerPlayer"));
            this.nodemap.put(KEY_CLASS_MINECRAFT, new ObfuscationEntry("net/minecraft/client/Minecraft"));
            this.nodemap.put(KEY_CLASS_SESSION, new ObfuscationEntry("net/minecraft/util/Session"));
            this.nodemap.put(KEY_CLASS_GUI_SCREEN, new ObfuscationEntry("net/minecraft/client/gui/GuiScreen"));
            this.nodemap.put(KEY_CLASS_ITEM_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/ItemRenderer"));
            this.nodemap.put(KEY_CLASS_VEC3, new ObfuscationEntry("net/minecraft/util/math/Vec3d"));
            this.nodemap.put(KEY_CLASS_ENTITY, new ObfuscationEntry("net/minecraft/entity/Entity"));
            this.nodemap.put(KEY_CLASS_GUI_SLEEP, new ObfuscationEntry("net/minecraft/client/gui/GuiSleepMP"));
            this.nodemap.put(KEY_CLASS_PARTICLE_MANAGER, new ObfuscationEntry("net/minecraft/client/particle/ParticleManager"));
            this.nodemap.put(KEY_CLASS_FORGE_HOOKS_CLIENT, new ObfuscationEntry("net/minecraftforge/client/ForgeHooksClient"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_MP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_SP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityClientPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_OTHER_PLAYER, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityOtherPlayerMP"));
            this.nodemap.put(KEY_CLASS_PACKET_SPAWN_PLAYER, new ObfuscationEntry("net/minecraft/network/play/server/SPacketSpawnPlayer"));
            this.nodemap.put(KEY_CLASS_ENTITY_OTHER_PLAYER, new ObfuscationEntry("net/minecraft/client/entity/EntityOtherPlayerMP"));
            this.nodemap.put(KEY_CLASS_SERVER, new ObfuscationEntry("net/minecraft/server/MinecraftServer"));
            this.nodemap.put(KEY_CLASS_WORLD_SERVER, new ObfuscationEntry("net/minecraft/world/WorldServer"));
            this.nodemap.put(KEY_CLASS_WORLD_CLIENT, new ObfuscationEntry("net/minecraft/client/multiplayer/WorldClient"));
            this.nodemap.put(KEY_CLASS_TILEENTITY, new ObfuscationEntry("net/minecraft/tileentity/TileEntity"));
            this.nodemap.put(KEY_CLASS_CHUNK_PROVIDER_OVERWORLD, new ObfuscationEntry("net/minecraft/world/gen/ChunkGeneratorOverworld"));
            this.nodemap.put(KEY_CLASS_ICHUNKPROVIDER, new ObfuscationEntry("net/minecraft/world/chunk/IChunkProvider"));
            this.nodemap.put(KEY_CLASS_ICHUNKGENERATOR, new ObfuscationEntry("net/minecraft/world/gen/IChunkGenerator"));
            this.nodemap.put(KEY_CLASS_CHUNK, new ObfuscationEntry("net/minecraft/world/chunk/Chunk"));
            this.nodemap.put(KEY_NET_HANDLER_LOGIN_SERVER, new ObfuscationEntry("net/minecraft/server/network/NetHandlerLoginServer"));
            this.nodemap.put(KEY_CLASS_ENTITY_ARROW, new ObfuscationEntry("net/minecraft/entity/projectile/EntityArrow"));
            this.nodemap.put(KEY_CLASS_ENTITYGOLEM, new ObfuscationEntry("net/minecraft/entity/monster/EntityGolem"));
            this.nodemap.put(KEY_CLASS_IBLOCKACCESS, new ObfuscationEntry("net/minecraft/world/IBlockAccess"));
            this.nodemap.put(KEY_CLASS_BLOCK, new ObfuscationEntry("net/minecraft/block/Block"));
            this.nodemap.put(KEY_CLASS_BLOCKPOS, new ObfuscationEntry("net/minecraft/util/math/BlockPos"));
            this.nodemap.put(KEY_CLASS_IBLOCKSTATE, new ObfuscationEntry("net/minecraft/block/state/IBlockState"));
            this.nodemap.put(KEY_CLASS_ICAMERA, new ObfuscationEntry("net/minecraft/client/renderer/culling/ICamera"));
            this.nodemap.put(KEY_CLASS_INTCACHE, new ObfuscationEntry("net/minecraft/world/gen/layer/IntCache"));
            this.nodemap.put(KEY_FIELD_CHUNK_XPOS, new FieldObfuscationEntry("x", "b"));
            this.nodemap.put(KEY_FIELD_CHUNK_ZPOS, new FieldObfuscationEntry("z", "c"));
            this.nodemap.put(KEY_FIELD_CHUNK_WORLD, new FieldObfuscationEntry(KEY_FIELD_CHUNK_WORLD, "k"));
            this.nodemap.put(KEY_METHOD_CREATE_PLAYER, new MethodObfuscationEntry("createPlayerForUser", "g", "(L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RESPAWN_PLAYER, new MethodObfuscationEntry("recreatePlayerEntity", "a", "(L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";IZ)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_CREATE_CLIENT_PLAYER, new MethodObfuscationEntry("createPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";L" + this.getNameDynamic(KEY_CLASS_RECIPE_BOOK) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_SP) + ";"));
            this.nodemap.put(KEY_METHOD_MOVE_ENTITY, new MethodObfuscationEntry("travel", "a", "(FFF)V"));
            this.nodemap.put(KEY_METHOD_ON_UPDATE, new MethodObfuscationEntry("onUpdate", "B_", "()V"));
            this.nodemap.put(KEY_METHOD_UPDATE_LIGHTMAP, new MethodObfuscationEntry("updateLightmap", "g", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDER_OVERLAYS, new MethodObfuscationEntry("renderOverlays", "b", "(F)V"));
            this.nodemap.put(KEY_METHOD_UPDATE_FOG_COLOR, new MethodObfuscationEntry("updateFogColor", "h", "(F)V"));
            this.nodemap.put(KEY_METHOD_GET_FOG_COLOR, new MethodObfuscationEntry("getFogColor", "f", "(F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_GET_SKY_COLOR, new MethodObfuscationEntry("getSkyColor", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_WAKE_ENTITY, new MethodObfuscationEntry("wakeFromSleep", "a", "()V"));
            this.nodemap.put(KEY_METHOD_BED_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_BED_ORIENT_CAMERA, "(L" + this.getNameDynamic(KEY_CLASS_IBLOCKACCESS) + ";L" + this.getNameDynamic(KEY_CLASS_BLOCKPOS) + ";L" + this.getNameDynamic(KEY_CLASS_IBLOCKSTATE) + ";L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDER_PARTICLES, new MethodObfuscationEntry("renderParticles", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_MP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_INTERACTION_MANAGER) + ";)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_SP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_NET_HANDLER_PLAY) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";L" + this.getNameDynamic(KEY_CLASS_RECIPE_BOOK) + ";)V"));
            this.nodemap.put(KEY_METHOD_HANDLE_SPAWN_PLAYER, new MethodObfuscationEntry("handleSpawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PACKET_SPAWN_PLAYER) + ";)V"));
            this.nodemap.put(KEY_METHOD_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_ORIENT_CAMERA, "f", "(F)V"));
            this.nodemap.put(KEY_METHOD_CAN_RENDER_FIRE, new MethodObfuscationEntry(KEY_METHOD_CAN_RENDER_FIRE, "bl", "()Z"));
            this.nodemap.put(KEY_METHOD_POPULATE_CHUNK, new MethodObfuscationEntry("populate", "a", "(L" + this.getNameDynamic(KEY_CLASS_ICHUNKGENERATOR) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDER_MODEL, new MethodObfuscationEntry(KEY_METHOD_RENDER_MODEL, "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";FFFFFF)V"));
            this.nodemap.put(KEY_METHOD_RAIN_STRENGTH, new MethodObfuscationEntry(KEY_METHOD_RAIN_STRENGTH, "j", "(F)F"));
            this.nodemap.put(KEY_METHOD_REGISTEROF, new MethodObfuscationEntry("register", "register", "()V"));
            this.nodemap.put(KEY_METHOD_SETUP_TERRAIN, new MethodObfuscationEntry(KEY_METHOD_SETUP_TERRAIN, "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DL" + this.getNameDynamic(KEY_CLASS_ICAMERA) + ";IZ)V"));
            this.nodemap.put(KEY_METHOD_GET_EYE_HEIGHT, new MethodObfuscationEntry(KEY_METHOD_GET_EYE_HEIGHT, "by", "()F"));
            this.nodemap.put(KEY_METHOD_ENABLE_ALPHA, new MethodObfuscationEntry("enableAlpha", "e", "()V"));
            this.nodemap.put(KEY_METHOD_VALIDATE, new MethodObfuscationEntry("validate", "func_145829_t", "()V"));
        }
        try {
            this.isServer = Launch.classLoader.getClassBytes(this.getNameDynamic(KEY_CLASS_RENDER_GLOBAL)) == null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        String testName;
        if (bytes == null) {
            return null;
        }
        if (name.startsWith("micdoodle8")) {
            if (name.equals("micdoodle8.mods.galacticraft.core.energy.tile.TileCableIC2Sealed")) {
                bytes = this.transformTileCableIC2Sealed(bytes);
            }
            return this.transformCustomAnnotations(bytes);
        }
        if (this.nameForgeHooksClient == null) {
            this.nameForgeHooksClient = this.getName(KEY_CLASS_FORGE_HOOKS_CLIENT);
            if (this.deobfuscated) {
                this.populateNamesDeObf();
            } else {
                this.populateNamesObf();
            }
        }
        if ((testName = name.replace('.', '/')).equals(this.nameForgeHooksClient)) {
            return this.transformForgeHooks(bytes);
        }
        if (testName.equals(CLASS_IFORGEARMOR)) {
            return this.transformForgeArmor(bytes);
        }
        if (testName.equals(CLASS_SYNCMOD_CLONEPLAYER)) {
            return this.transformSyncMod(bytes);
        }
        if (testName.equals(CLASS_RENDERPLAYEROF)) {
            return this.transformOptifine(bytes);
        }
        if (testName.equals("ic2/core/block/TileEntityBlock")) {
            ClassNode node = this.startInjection(bytes);
            MethodNode method = this.getMethod(node, KEY_METHOD_VALIDATE);
            method.access &= 0xFFFFFFEF;
            return this.finishInjection(node);
        }
        if (testName.equals("appeng/worldgen/MeteoritePlacer")) {
            return this.transformAEMeteorite(bytes);
        }
        bytes = this.transformRefs(bytes);
        if (testName.length() <= 3 || this.deobfuscated) {
            return this.transformVanilla(testName, bytes);
        }
        return bytes;
    }

    private void populateNamesDeObf() {
        this.namePlayerList = this.getName(KEY_PLAYER_LIST);
        this.namePlayerController = this.getName(KEY_CLASS_PLAYER_CONTROLLER);
        this.nameEntityLiving = this.getName(KEY_CLASS_ENTITY_LIVING);
        this.nameEntityItem = this.getName(KEY_CLASS_ENTITY_ITEM);
        this.nameEntityRenderer = this.getName(KEY_CLASS_ENTITY_RENDERER);
        this.nameItemRenderer = this.getName(KEY_CLASS_ITEM_RENDERER);
        this.nameGuiSleep = this.getName(KEY_CLASS_GUI_SLEEP);
        this.nameParticleManager = this.getName(KEY_CLASS_PARTICLE_MANAGER);
        this.nameNetHandlerPlay = this.getName(KEY_CLASS_NET_HANDLER_PLAY);
        this.nameRenderGlobal = this.getName(KEY_CLASS_RENDER_GLOBAL);
        this.nameRenderManager = this.getName(KEY_CLASS_RENDER_MANAGER);
        this.nameEntity = this.getName(KEY_CLASS_ENTITY);
        this.nameChunkGeneratorOverworld = this.getName(KEY_CLASS_CHUNK_PROVIDER_OVERWORLD);
        this.nameChunk = this.getName(KEY_CLASS_CHUNK);
        this.nameEntityArrow = this.getName(KEY_CLASS_ENTITY_ARROW);
        this.nameEntityGolem = this.getName(KEY_CLASS_ENTITYGOLEM);
        this.nameWorld = this.getName(KEY_CLASS_WORLD);
    }

    private void populateNamesObf() {
        this.namePlayerList = this.nodemap.get((Object)KEY_PLAYER_LIST).obfuscatedName;
        this.namePlayerController = this.nodemap.get((Object)KEY_CLASS_PLAYER_CONTROLLER).obfuscatedName;
        this.nameEntityLiving = this.nodemap.get((Object)KEY_CLASS_ENTITY_LIVING).obfuscatedName;
        this.nameEntityItem = this.nodemap.get((Object)KEY_CLASS_ENTITY_ITEM).obfuscatedName;
        this.nameEntityRenderer = this.nodemap.get((Object)KEY_CLASS_ENTITY_RENDERER).obfuscatedName;
        this.nameItemRenderer = this.nodemap.get((Object)KEY_CLASS_ITEM_RENDERER).obfuscatedName;
        this.nameGuiSleep = this.nodemap.get((Object)KEY_CLASS_GUI_SLEEP).obfuscatedName;
        this.nameParticleManager = this.nodemap.get((Object)KEY_CLASS_PARTICLE_MANAGER).obfuscatedName;
        this.nameNetHandlerPlay = this.nodemap.get((Object)KEY_CLASS_NET_HANDLER_PLAY).obfuscatedName;
        this.nameRenderGlobal = this.nodemap.get((Object)KEY_CLASS_RENDER_GLOBAL).obfuscatedName;
        this.nameRenderManager = this.nodemap.get((Object)KEY_CLASS_RENDER_MANAGER).obfuscatedName;
        this.nameEntity = this.nodemap.get((Object)KEY_CLASS_ENTITY).obfuscatedName;
        this.nameChunkGeneratorOverworld = this.nodemap.get((Object)KEY_CLASS_CHUNK_PROVIDER_OVERWORLD).obfuscatedName;
        this.nameChunk = this.nodemap.get((Object)KEY_CLASS_CHUNK).obfuscatedName;
        this.nameEntityArrow = this.nodemap.get((Object)KEY_CLASS_ENTITY_ARROW).obfuscatedName;
        this.nameEntityGolem = this.nodemap.get((Object)KEY_CLASS_ENTITYGOLEM).obfuscatedName;
        this.nameWorld = this.nodemap.get((Object)KEY_CLASS_WORLD).obfuscatedName;
    }

    private byte[] transformVanilla(String testName, byte[] bytes) {
        if (testName.equals(this.namePlayerList)) {
            return this.transformPlayerList(bytes);
        }
        if (testName.equals(this.namePlayerController)) {
            return this.transformPlayerController(bytes);
        }
        if (testName.equals(this.nameEntityLiving)) {
            return this.transformEntityLiving(bytes);
        }
        if (testName.equals(this.nameEntityItem)) {
            return this.transformEntityItem(bytes);
        }
        if (testName.equals(this.nameEntityRenderer)) {
            return this.transformEntityRenderer(bytes);
        }
        if (testName.equals(this.nameItemRenderer)) {
            return this.transformItemRenderer(bytes);
        }
        if (testName.equals(this.nameGuiSleep)) {
            return this.transformGuiSleep(bytes);
        }
        if (testName.equals(this.nameParticleManager)) {
            return this.transformParticleManager(bytes);
        }
        if (testName.equals(this.nameNetHandlerPlay)) {
            return this.transformNetHandlerPlay(bytes);
        }
        if (testName.equals(this.nameRenderGlobal)) {
            return this.transformRenderGlobal(bytes);
        }
        if (testName.equals(this.nameEntity)) {
            return this.transformEntityClass(bytes);
        }
        if (testName.equals(this.nameChunk)) {
            return this.transformChunkClass(bytes);
        }
        if (testName.equals(this.nameEntityArrow)) {
            return this.transformEntityArrow(bytes);
        }
        if (testName.equals(this.nameEntityGolem)) {
            return this.transformEntityGolem(bytes);
        }
        if (testName.equals(this.nameWorld)) {
            return this.transformWorld(bytes);
        }
        return bytes;
    }

    public byte[] transformChunkClass(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode populateMethod = this.getMethod(node, KEY_METHOD_POPULATE_CHUNK);
        if (populateMethod != null) {
            for (int count = populateMethod.instructions.size() - 1; count > 0; --count) {
                MethodInsnNode nodeAt;
                AbstractInsnNode list = populateMethod.instructions.get(count);
                if (!(list instanceof MethodInsnNode) || (nodeAt = (MethodInsnNode)list).getOpcode() != 184 || !nodeAt.owner.contains("GameRegistry")) continue;
                MethodInsnNode hook = new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "otherModGenerate", "(IIL" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_ICHUNKGENERATOR) + ";L" + this.getNameDynamic(KEY_CLASS_ICHUNKPROVIDER) + ";)V", false);
                populateMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)hook);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformPlayerList(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        boolean playerAPI = this.isPlayerApiActive();
        int n = operationCount = playerAPI ? 0 : 4;
        if (!playerAPI) {
            TypeInsnNode overwriteNode;
            TypeInsnNode nodeAt;
            AbstractInsnNode list;
            int count;
            MethodNode createPlayerMethod = this.getMethod(node, KEY_METHOD_CREATE_PLAYER);
            MethodNode respawnPlayerMethod = this.getMethod(node, KEY_METHOD_RESPAWN_PLAYER);
            if (createPlayerMethod != null) {
                for (count = 0; count < createPlayerMethod.instructions.size(); ++count) {
                    list = createPlayerMethod.instructions.get(count);
                    if (list instanceof TypeInsnNode) {
                        nodeAt = (TypeInsnNode)list;
                        if (nodeAt.getOpcode() == 192 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                        overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                        createPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        continue;
                    }
                    if (!(list instanceof MethodInsnNode)) continue;
                    nodeAt = (MethodInsnNode)list;
                    if (!nodeAt.owner.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP)) || nodeAt.getOpcode() != 183) continue;
                    createPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP), false));
                    ++injectionCount;
                }
            }
            if (respawnPlayerMethod != null) {
                for (count = 0; count < respawnPlayerMethod.instructions.size(); ++count) {
                    list = respawnPlayerMethod.instructions.get(count);
                    if (list instanceof TypeInsnNode) {
                        nodeAt = (TypeInsnNode)list;
                        if (nodeAt.getOpcode() == 192 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                        overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                        respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        continue;
                    }
                    if (!(list instanceof MethodInsnNode)) continue;
                    nodeAt = (MethodInsnNode)list;
                    if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                    respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP), false));
                    ++injectionCount;
                }
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformSyncMod(byte[] bytes) {
        MethodNode respawnPlayerMethod;
        ClassNode node = this.startInjection(bytes);
        boolean playerAPI = this.isPlayerApiActive();
        int n = operationCount = playerAPI ? 0 : 2;
        if (!playerAPI && (respawnPlayerMethod = this.getMethodNoDesc(node, "func_145845_h")) != null) {
            for (int count = 0; count < respawnPlayerMethod.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = respawnPlayerMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (nodeAt.getOpcode() != 187 || !nodeAt.desc.contains(this.getName(KEY_CLASS_PLAYER_MP))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                    respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getName(KEY_CLASS_PLAYER_MP))) continue;
                respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP)));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformPlayerController(byte[] bytes) {
        MethodNode method;
        ClassNode node = this.startInjection(bytes);
        boolean playerAPI = this.isPlayerApiActive();
        int n = operationCount = playerAPI ? 0 : 2;
        if (!playerAPI && (method = this.getMethod(node, KEY_METHOD_CREATE_CLIENT_PLAYER)) != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = method.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (!nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_SP))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_SP));
                    method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_SP))) continue;
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_SP), this.getName(KEY_METHOD_CUSTOM_PLAYER_SP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_SP)));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityLiving(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_MOVE_ENTITY);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(0.08)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getGravityForEntity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)D");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityItem(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_ON_UPDATE);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(0.04f)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getItemGravity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_ITEM) + ";)D");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityRenderer(byte[] bytes) {
        AbstractInsnNode list;
        int count;
        ClassNode node = this.startInjection(bytes);
        operationCount = 6;
        MethodNode updateLightMapMethod = this.getMethod(node, KEY_METHOD_UPDATE_LIGHTMAP);
        MethodNode updateFogColorMethod = this.getMethod(node, KEY_METHOD_UPDATE_FOG_COLOR);
        MethodNode orientCameraMethod = this.getMethod(node, KEY_METHOD_ORIENT_CAMERA);
        if (orientCameraMethod != null) {
            InsnList nodesToAdd = new InsnList();
            nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
            nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, KEY_METHOD_ORIENT_CAMERA, "(F)V"));
            orientCameraMethod.instructions.insertBefore(orientCameraMethod.instructions.get(orientCameraMethod.instructions.size() - 3), nodesToAdd);
            ++injectionCount;
            for (count = 0; count < orientCameraMethod.instructions.size(); ++count) {
                VarInsnNode varNode;
                list = orientCameraMethod.instructions.get(count);
                if (!(list instanceof VarInsnNode) || (varNode = (VarInsnNode)list).getOpcode() != 57 || varNode.var != 10) continue;
                nodesToAdd.clear();
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(24, 10));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getCameraZoom", "(D)D"));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(57, 10));
                orientCameraMethod.instructions.insert(list.getNext(), nodesToAdd);
                ++injectionCount;
                break;
            }
            if (ConfigManagerMicCore.enableDebug) {
                System.out.println("bll.OrientCamera done");
            }
        }
        if (updateLightMapMethod != null) {
            boolean worldBrightnessInjection = false;
            for (count = 0; count < updateLightMapMethod.instructions.size(); ++count) {
                MethodInsnNode nodeAt;
                list = updateLightMapMethod.instructions.get(count);
                if (list instanceof MethodInsnNode) {
                    nodeAt = (MethodInsnNode)list;
                    if (!worldBrightnessInjection && nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_WORLD))) {
                        updateLightMapMethod.instructions.remove(updateLightMapMethod.instructions.get(count - 1));
                        updateLightMapMethod.instructions.set(updateLightMapMethod.instructions.get(count - 1), (AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getWorldBrightness", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                        ++injectionCount;
                        worldBrightnessInjection = true;
                        if (!ConfigManagerMicCore.enableDebug) continue;
                        System.out.println("bll.updateLightMap - worldBrightness done");
                        continue;
                    }
                }
                if (!(list instanceof IntInsnNode)) continue;
                nodeAt = (IntInsnNode)list;
                if (nodeAt.operand != 255) continue;
                InsnList nodesToAdd = new InsnList();
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 12));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getColorRed", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 12));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 13));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getColorGreen", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 13));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 14));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getColorBlue", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 14));
                updateLightMapMethod.instructions.insertBefore((AbstractInsnNode)nodeAt, nodesToAdd);
                ++injectionCount;
                if (!ConfigManagerMicCore.enableDebug) break;
                System.out.println("bll.updateLightMap - getColors done");
                break;
            }
        }
        if (updateFogColorMethod != null) {
            for (int count2 = 0; count2 < updateFogColorMethod.instructions.size(); ++count2) {
                InsnList toAdd;
                AbstractInsnNode list2 = updateFogColorMethod.instructions.get(count2);
                if (!(list2 instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)list2;
                if (!this.optifinePresent && this.methodMatches(KEY_METHOD_GET_FOG_COLOR, nodeAt)) {
                    toAdd = new InsnList();
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getFogColorHook", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(58, 9));
                    updateFogColorMethod.instructions.insertBefore(updateFogColorMethod.instructions.get(count2 + 2), toAdd);
                    ++injectionCount;
                    if (!ConfigManagerMicCore.enableDebug) continue;
                    System.out.println("bll.updateFogColor - getFogColor (no Optifine) done");
                    continue;
                }
                if (!this.methodMatches(KEY_METHOD_GET_SKY_COLOR, nodeAt)) continue;
                toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getSkyColorHook", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
                toAdd.add((AbstractInsnNode)new VarInsnNode(58, 5));
                updateFogColorMethod.instructions.insertBefore(updateFogColorMethod.instructions.get(count2 + 2), toAdd);
                ++injectionCount;
                if (!ConfigManagerMicCore.enableDebug) continue;
                System.out.println("bll.updateFogColor - getSkyColor done");
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformGuiSleep(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_WAKE_ENTITY);
        if (method != null) {
            method.instructions.insertBefore(method.instructions.get(method.instructions.size() - 3), (AbstractInsnNode)new MethodInsnNode(184, CLASS_MICDOODLE_PLUGIN, "onSleepCancelled", "()V"));
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformForgeHooks(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_BED_ORIENT_CAMERA);
        if (method != null) {
            method.instructions.insertBefore(method.instructions.get(0), (AbstractInsnNode)new MethodInsnNode(184, CLASS_MICDOODLE_PLUGIN, KEY_METHOD_ORIENT_CAMERA, "()V"));
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformForgeArmor(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("applyArmor")) continue;
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode target;
                AbstractInsnNode test = method.instructions.get(count);
                if (test.getOpcode() != 180 || !((FieldInsnNode)test).name.equals("AbsorbRatio") || (target = method.instructions.get(count + 1)).getOpcode() != 107) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "armorDamageHook", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)D", false));
                toAdd.add((AbstractInsnNode)new InsnNode(107));
                method.instructions.insert(target, toAdd);
                ++injectionCount;
                continue block0;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityGolem(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 0;
        injectionCount = 0;
        String inter = CLASS_IENTITYBREATHABLE;
        try {
            Class.forName(inter.replace("/", "."));
            if (!node.interfaces.contains(inter)) {
                node.interfaces.add(inter);
                ++injectionCount;
            }
            MethodNode canBreathe = new MethodNode(1, "canBreath", "()Z", null, null);
            canBreathe.instructions.add((AbstractInsnNode)new InsnNode(4));
            canBreathe.instructions.add((AbstractInsnNode)new InsnNode(172));
            node.methods.add(canBreathe);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.finishInjection(node);
    }

    public byte[] transformTileCableIC2Sealed(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethodNoDesc(node, "<init>");
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode insn = method.instructions.get(count);
                if (!(insn instanceof MethodInsnNode)) continue;
                ((MethodInsnNode)insn).owner = "ic2/core/block/wiring/TileEntityCable";
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformCustomAnnotations(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 0;
        injectionCount = 0;
        Iterator methods = node.methods.iterator();
        ArrayList<String> ignoredMods = new ArrayList<String>();
        block2: while (methods.hasNext()) {
            MethodNode methodnode = (MethodNode)methods.next();
            if (methodnode.visibleAnnotations == null || methodnode.visibleAnnotations.size() <= 0) continue;
            for (AnnotationNode annotation : methodnode.visibleAnnotations) {
                boolean modFound;
                if (!annotation.desc.equals("Lmicdoodle8/mods/miccore/Annotations$RuntimeInterface;")) continue;
                ArrayList<String> desiredInterfaces = new ArrayList<String>();
                String modID = "";
                String deobfName = "";
                for (int i = 0; i < annotation.values.size(); i += 2) {
                    Object value = annotation.values.get(i);
                    if (value.equals("clazz")) {
                        desiredInterfaces.add(String.valueOf(annotation.values.get(i + 1)));
                        continue;
                    }
                    if (value.equals("modID")) {
                        modID = String.valueOf(annotation.values.get(i + 1));
                        continue;
                    }
                    if (value.equals("altClasses")) {
                        desiredInterfaces.addAll((ArrayList)annotation.values.get(i + 1));
                        continue;
                    }
                    if (!value.equals("deobfName")) continue;
                    deobfName = String.valueOf(annotation.values.get(i + 1));
                }
                if (!modID.isEmpty() && ignoredMods.contains(modID)) continue block2;
                boolean bl = modFound = modID.isEmpty() || Loader.isModLoaded((String)modID);
                if (modFound) {
                    for (String inter : desiredInterfaces) {
                        try {
                            Class.forName(inter);
                        }
                        catch (ClassNotFoundException e) {
                            if (!ConfigManagerMicCore.enableDebug) continue;
                            this.printLog("Galacticraft ignored missing interface \"" + inter + "\" from mod \"" + modID + "\".");
                            continue;
                        }
                        inter = inter.replace(".", "/");
                        if (deobfName.equals("EXTENDS")) {
                            if (ConfigManagerMicCore.enableDebug) {
                                this.printLog("Galacticraft added superclass \"" + inter + "\" dynamically from \"" + modID + "\" to class \"" + node.name + "\".");
                            }
                            node.superName = inter;
                            ++injectionCount;
                            continue;
                        }
                        if (node.interfaces.contains(inter)) continue block2;
                        if (ConfigManagerMicCore.enableDebug) {
                            this.printLog("Galacticraft added interface \"" + inter + "\" dynamically from \"" + modID + "\" to class \"" + node.name + "\".");
                        }
                        node.interfaces.add(inter);
                        ++injectionCount;
                        if (deobfName.isEmpty() || this.deobfuscated) continue block2;
                        String nameBefore = methodnode.name;
                        methodnode.name = deobfName;
                        if (!ConfigManagerMicCore.enableDebug) continue block2;
                        this.printLog("Galacticraft renamed method " + nameBefore + " to " + deobfName + " in class " + node.name);
                        continue block2;
                    }
                    continue block2;
                }
                ignoredMods.add(modID);
                if (!ConfigManagerMicCore.enableDebug) continue block2;
                this.printLog("Galacticraft ignored dynamic interface insertion since \"" + modID + "\" was not found.");
                continue block2;
            }
        }
        if (injectionCount > 0 && ConfigManagerMicCore.enableDebug) {
            this.printLog("Galacticraft successfully injected bytecode into: " + node.name + " (" + injectionCount + ")");
        }
        return this.finishInjection(node, false);
    }

    public byte[] transformParticleManager(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode renderParticlesMethod = this.getMethod(node, KEY_METHOD_RENDER_PARTICLES);
        if (renderParticlesMethod != null) {
            InsnList toAdd = new InsnList();
            toAdd.add((AbstractInsnNode)new VarInsnNode(23, 2));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "renderFootprints", "(F)V", false));
            renderParticlesMethod.instructions.insert(renderParticlesMethod.instructions.get(0), toAdd);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformItemRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode renderOverlaysMethod = this.getMethod(node, KEY_METHOD_RENDER_OVERLAYS);
        if (renderOverlaysMethod != null) {
            for (int count = 0; count < renderOverlaysMethod.instructions.size(); ++count) {
                AbstractInsnNode glEnable = renderOverlaysMethod.instructions.get(count);
                if (!(glEnable instanceof MethodInsnNode) || !((MethodInsnNode)glEnable).name.equals(this.getNameDynamic(KEY_METHOD_ENABLE_ALPHA))) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "renderLiquidOverlays", "(F)V", false));
                renderOverlaysMethod.instructions.insertBefore(glEnable, toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformNetHandlerPlay(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 2;
        MethodNode handleNamedSpawnMethod = this.getMethod(node, KEY_METHOD_HANDLE_SPAWN_PLAYER);
        if (handleNamedSpawnMethod != null) {
            for (int count = 0; count < handleNamedSpawnMethod.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = handleNamedSpawnMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (!nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_ENTITY_OTHER_PLAYER))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getNameDynamic(KEY_CLASS_CUSTOM_OTHER_PLAYER));
                    handleNamedSpawnMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_ENTITY_OTHER_PLAYER))) continue;
                handleNamedSpawnMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getNameDynamic(KEY_CLASS_CUSTOM_OTHER_PLAYER), "<init>", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)V"));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRenderGlobal(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode setupTerrainMethod = this.getMethod(node, KEY_METHOD_SETUP_TERRAIN);
        if (setupTerrainMethod != null) {
            for (int count = 0; count < setupTerrainMethod.instructions.size(); ++count) {
                AbstractInsnNode nodeTest = setupTerrainMethod.instructions.get(count);
                if (!(nodeTest instanceof MethodInsnNode) || !((MethodInsnNode)nodeTest).name.equals(this.getNameDynamic(KEY_METHOD_GET_EYE_HEIGHT))) continue;
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(24, 15));
                list.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getRenderPosY", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";D)D", false));
                setupTerrainMethod.instructions.remove(setupTerrainMethod.instructions.get(count - 2));
                setupTerrainMethod.instructions.remove(setupTerrainMethod.instructions.get(count - 2));
                setupTerrainMethod.instructions.remove(setupTerrainMethod.instructions.get(count - 2));
                setupTerrainMethod.instructions.remove(setupTerrainMethod.instructions.get(count - 2));
                setupTerrainMethod.instructions.remove(setupTerrainMethod.instructions.get(count - 2));
                setupTerrainMethod.instructions.insertBefore(setupTerrainMethod.instructions.get(count - 2), list);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityClass(byte[] bytes) {
        if (this.isServer) {
            return bytes;
        }
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_CAN_RENDER_FIRE);
        if (method != null) {
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode nodeAt = method.instructions.get(i);
                if (!(nodeAt instanceof MethodInsnNode) || nodeAt.getOpcode() != 182) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "shouldRenderFire", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)Z", false);
                method.instructions.set(nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityArrow(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_ON_UPDATE);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(Float.valueOf(0.05f))) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "getArrowGravity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_ARROW) + ";)F", false);
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformWorld(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_RAIN_STRENGTH);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (list.getOpcode() != 25) continue;
                if (count + 10 >= method.instructions.size()) {
                    MicdoodlePlugin.showErrorDialog(new Object[]{"Exit", "Ignore"}, "Are there two copies of MicdoodleCore in your mods folder?  Please remove one!");
                    break;
                }
                for (int i = 0; i < 10; ++i) {
                    AbstractInsnNode removed = method.instructions.get(count);
                    method.instructions.remove(removed);
                }
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, KEY_METHOD_RAIN_STRENGTH, "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";F)F"));
                method.instructions.insertBefore(method.instructions.get(count), toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformOptifine(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_REGISTEROF);
        if (method != null) {
            InsnNode toAdd = new InsnNode(177);
            method.instructions.insertBefore(method.instructions.get(0), (AbstractInsnNode)toAdd);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformAEMeteorite(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        MethodNode method = this.getMethodNoDesc(node, "<init>");
        operationCount = 1;
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (list.getOpcode() != 180 || !((FieldInsnNode)list).name.equals("skyStoneDefinition")) continue;
                MethodInsnNode toAdd = new MethodInsnNode(184, CLASS_TRANSFORMER_HOOKS, "addAE2MeteorSpawn", "(Ljava/lang/Object;L" + this.getNameDynamic(KEY_CLASS_BLOCK) + ";)Z");
                method.instructions.set(method.instructions.get(count - 5), (AbstractInsnNode)toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRefs(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        String intCache1 = this.getName(KEY_CLASS_INTCACHE);
        String intCache2 = this.getObfName(KEY_CLASS_INTCACHE);
        int invokeStatic = 184;
        for (MethodNode m : node.methods) {
            int listsize = m.instructions.size();
            for (int count = 0; count < listsize; ++count) {
                if (m.instructions.get(count).getOpcode() != invokeStatic) continue;
                MethodInsnNode mn = (MethodInsnNode)m.instructions.get(count);
                if (!mn.owner.equals(intCache1) && !mn.owner.equals(intCache2)) continue;
                mn.owner = CLASS_INTCACHE_VARIANT;
            }
        }
        return this.finishInjection(node, false);
    }

    private void printResultsAndReset(String nodeName) {
        if (operationCount > 0) {
            if (injectionCount >= operationCount) {
                if (ConfigManagerMicCore.enableDebug) {
                    this.printLog("Galacticraft successfully injected bytecode into: " + nodeName + " (" + injectionCount + " / " + operationCount + ")");
                }
            } else {
                System.err.println("Potential problem: Galacticraft did not complete injection of bytecode into: " + nodeName + " (" + injectionCount + " / " + operationCount + ")");
            }
        }
    }

    private MethodNode getMethod(ClassNode node, String keyName) {
        for (MethodNode methodNode : node.methods) {
            if (!this.methodMatches(keyName, methodNode)) continue;
            return methodNode;
        }
        return null;
    }

    private MethodNode getMethodNoDesc(ClassNode node, String methodName) {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(methodName)) continue;
            return methodNode;
        }
        return null;
    }

    private boolean methodMatches(String keyName, MethodInsnNode node) {
        return node.name.equals(this.getNameDynamic(keyName)) && node.desc.equals(this.getDescDynamic(keyName));
    }

    private boolean methodMatches(String keyName, MethodNode node) {
        return node.name.equals(this.getNameDynamic(keyName)) && node.desc.equals(this.getDescDynamic(keyName));
    }

    public String getName(String keyName) {
        return this.nodemap.get((Object)keyName).name;
    }

    public String getObfName(String keyName) {
        return this.nodemap.get((Object)keyName).obfuscatedName;
    }

    public String getNameDynamic(String keyName) {
        try {
            if (this.deobfuscated) {
                return this.getName(keyName);
            }
            return this.getObfName(keyName);
        }
        catch (NullPointerException e) {
            System.err.println("Could not find key: " + keyName);
            throw e;
        }
    }

    public String getDescDynamic(String keyName) {
        return ((MethodObfuscationEntry)this.nodemap.get((Object)keyName)).methodDesc;
    }

    private void printLog(String message) {
        FMLLog.info((String)message, (Object[])new Object[0]);
    }

    private ClassNode startInjection(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        injectionCount = 0;
        operationCount = 0;
        return node;
    }

    private byte[] finishInjection(ClassNode node) {
        return this.finishInjection(node, true);
    }

    private byte[] finishInjection(ClassNode node, boolean printToLog) {
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        if (printToLog) {
            this.printResultsAndReset(node.name);
        }
        return writer.toByteArray();
    }

    private boolean isPlayerApiActive() {
        return this.playerApiActive;
    }

    private boolean mcVersionMatches(String testVersion) {
        return testVersion.contains(this.mcVersion);
    }

    public static class FieldObfuscationEntry
    extends ObfuscationEntry {
        public FieldObfuscationEntry(String name, String obfuscatedName) {
            super(name, obfuscatedName);
        }
    }

    public static class MethodObfuscationEntry
    extends ObfuscationEntry {
        public String methodDesc;

        public MethodObfuscationEntry(String name, String obfuscatedName, String methodDesc) {
            super(name, obfuscatedName);
            this.methodDesc = methodDesc;
        }

        public MethodObfuscationEntry(String commonName, String methodDesc) {
            this(commonName, commonName, methodDesc);
        }
    }

    public static class ObfuscationEntry {
        public String name;
        public String obfuscatedName;

        public ObfuscationEntry(String name, String obfuscatedName) {
            this.name = name;
            this.obfuscatedName = obfuscatedName;
        }

        public ObfuscationEntry(String name) {
            this(name, FMLDeobfuscatingRemapper.INSTANCE.unmap(name));
        }
    }
}

