/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.nbt.NBTTagCompound;

public class ChemicalPairOutput
extends MachineOutput<ChemicalPairOutput> {
    public GasStack leftGas;
    public GasStack rightGas;

    public ChemicalPairOutput(GasStack left, GasStack right) {
        this.leftGas = left;
        this.rightGas = right;
    }

    public ChemicalPairOutput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.leftGas = GasStack.readFromNBT(nbtTags.func_74775_l("leftOutput"));
        this.rightGas = GasStack.readFromNBT(nbtTags.func_74775_l("rightOutput"));
    }

    public boolean isValid() {
        return this.leftGas != null && this.rightGas != null;
    }

    public boolean meetsInput(ChemicalPairOutput input) {
        return this.meets(input) || this.meets(input.swap());
    }

    public ChemicalPairOutput swap() {
        return new ChemicalPairOutput(this.rightGas, this.leftGas);
    }

    public boolean applyOutputs(GasTank leftTank, GasTank rightTank, boolean doEmit, int scale) {
        if (leftTank.canReceive(this.leftGas.getGas()) && rightTank.canReceive(this.rightGas.getGas())) {
            if (leftTank.getNeeded() >= this.leftGas.amount * scale && rightTank.getNeeded() >= this.rightGas.amount * scale) {
                leftTank.receive(this.leftGas.copy().withAmount(this.leftGas.amount * scale), doEmit);
                rightTank.receive(this.rightGas.copy().withAmount(this.rightGas.amount * scale), doEmit);
                return true;
            }
        } else if (leftTank.canReceive(this.rightGas.getGas()) && rightTank.canReceive(this.leftGas.getGas()) && leftTank.getNeeded() >= this.rightGas.amount * scale && rightTank.getNeeded() >= this.leftGas.amount * scale) {
            leftTank.receive(this.rightGas.copy().withAmount(this.rightGas.amount * scale), doEmit);
            rightTank.receive(this.leftGas.copy().withAmount(this.leftGas.amount * scale), doEmit);
            return true;
        }
        return false;
    }

    public void draw(GasTank leftTank, GasTank rightTank) {
        if (this.meets(new ChemicalPairOutput(leftTank.getGas(), rightTank.getGas()))) {
            leftTank.draw(this.leftGas.amount, true);
            rightTank.draw(this.rightGas.amount, true);
        } else if (this.meets(new ChemicalPairOutput(rightTank.getGas(), leftTank.getGas()))) {
            leftTank.draw(this.rightGas.amount, true);
            rightTank.draw(this.leftGas.amount, true);
        }
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.leftGas) || stack.isGasEqual(this.rightGas);
    }

    private boolean meets(ChemicalPairOutput input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (input.leftGas.getGas() != this.leftGas.getGas() || input.rightGas.getGas() != this.rightGas.getGas()) {
            return false;
        }
        return input.leftGas.amount >= this.leftGas.amount && input.rightGas.amount >= this.rightGas.amount;
    }

    @Override
    public ChemicalPairOutput copy() {
        return new ChemicalPairOutput(this.leftGas.copy(), this.rightGas.copy());
    }
}

