/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.EnumSet;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;

public class TileBaseUniversalElectricalSource
extends TileBaseUniversalElectrical {
    public float produce() {
        this.storage.maxExtractRemaining = this.storage.maxExtract;
        float produced = this.extractEnergyGC(null, this.produce(false), false);
        this.storage.maxExtractRemaining -= produced;
        if (this.storage.maxExtractRemaining < 0.0f) {
            this.storage.maxExtractRemaining = 0.0f;
        }
        return produced;
    }

    public float produce(boolean simulate) {
        float amountProduced = 0.0f;
        if (!this.field_145850_b.field_72995_K) {
            EnumSet<EnumFacing> outputDirections = this.getElectricalOutputDirections();
            BlockVec3 thisVec = new BlockVec3(this);
            for (EnumFacing direction : outputDirections) {
                float toSend;
                TileEntity tileAdj = thisVec.getTileEntityOnSide(this.field_145850_b, direction);
                if (tileAdj == null || (toSend = this.extractEnergyGC(null, Math.min(this.getEnergyStoredGC() - amountProduced, this.getEnergyStoredGC() / (float)outputDirections.size()), true)) <= 0.0f) continue;
                if (tileAdj instanceof TileBaseConductor && ((TileBaseConductor)tileAdj).canConnect(direction.func_176734_d(), NetworkType.POWER)) {
                    IElectricityNetwork network = ((IConductor)tileAdj).getNetwork();
                    if (network == null) continue;
                    amountProduced += toSend - network.produce(toSend, !simulate, this.tierGC, this);
                    continue;
                }
                if (tileAdj instanceof TileBaseUniversalElectrical) {
                    amountProduced += ((TileBaseUniversalElectrical)tileAdj).receiveElectricity(direction.func_176734_d(), toSend, this.tierGC, !simulate);
                    continue;
                }
                amountProduced += EnergyUtil.otherModsEnergyTransfer(tileAdj, direction.func_176734_d(), toSend, simulate);
            }
        }
        return amountProduced;
    }

    public void recharge(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float maxExtractSave = this.storage.getMaxExtract();
            if (this.tierGC > 1) {
                this.storage.setMaxExtract(maxExtractSave * 2.5f);
            }
            float energyToCharge = this.storage.extractEnergyGC(this.storage.getMaxExtract(), true);
            if (item instanceof IItemElectric) {
                this.storage.extractEnergyGC(ElectricItemHelper.chargeItem(itemStack, energyToCharge), false);
            } else if (EnergyConfigHandler.isMekanismLoaded() && item instanceof IEnergizedItem && ((IEnergizedItem)item).canReceive(itemStack)) {
                this.storage.extractEnergyGC((float)EnergizedItemManager.charge((ItemStack)itemStack, (double)(energyToCharge * EnergyConfigHandler.TO_MEKANISM_RATIO)) / EnergyConfigHandler.TO_MEKANISM_RATIO, false);
            } else if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                if (item instanceof ISpecialElectricItem) {
                    ISpecialElectricItem specialElectricItem = (ISpecialElectricItem)item;
                    IElectricItemManager manager = specialElectricItem.getManager(itemStack);
                    double result = manager.charge(itemStack, (double)(energyToCharge * EnergyConfigHandler.TO_IC2_RATIO), this.tierGC + 1, false, false);
                    float energy = (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                    this.storage.extractEnergyGC(energy, false);
                } else if (item instanceof IElectricItem) {
                    double result = ElectricItem.manager.charge(itemStack, (double)(energyToCharge * EnergyConfigHandler.TO_IC2_RATIO), this.tierGC + 1, false, false);
                    float energy = (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                    this.storage.extractEnergyGC(energy, false);
                }
            }
            if (this.tierGC > 1) {
                this.storage.setMaxExtract(maxExtractSave);
            }
        }
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyEmitter", modID="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        if (this.field_145846_f) {
            return false;
        }
        if (receiver instanceof IElectrical || receiver instanceof IConductor || !(receiver instanceof IEnergyTile)) {
            return false;
        }
        return this.getElectricalOutputDirections().contains(direction);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="ic2")
    public double getOfferedEnergy() {
        if (EnergyConfigHandler.disableIC2Output) {
            return 0.0;
        }
        return this.getProvide(null) * EnergyConfigHandler.TO_IC2_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="ic2")
    public void drawEnergy(double amount) {
        if (EnergyConfigHandler.disableIC2Output) {
            return;
        }
        this.storage.extractEnergyGC((float)amount / EnergyConfigHandler.TO_IC2_RATIO, false);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="ic2")
    public int getSourceTier() {
        return this.tierGC + 1;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyOutputter", modID="mekanism")
    public boolean canOutputEnergy(EnumFacing side) {
        return this.getElectricalOutputDirections().contains(side);
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyOutputter", modID="mekanism")
    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        if (this.canOutputEnergy(side)) {
            float amountGC = (float)amount / EnergyConfigHandler.TO_MEKANISM_RATIO;
            return this.storage.extractEnergyGC(amountGC, simulate) * EnergyConfigHandler.TO_MEKANISM_RATIO;
        }
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyStorage", modID="mekanism")
    public double getEnergy() {
        return this.storage.getEnergyStoredGC() * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyStorage", modID="mekanism")
    public double getMaxEnergy() {
        return this.storage.getCapacityGC() * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyStorage", modID="mekanism")
    public void setEnergy(double energy) {
        this.storage.setEnergyStored((float)energy / EnergyConfigHandler.TO_MEKANISM_RATIO);
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing side) {
        if (cap != null && (cap == EnergyUtil.mekCableOutput || cap == EnergyUtil.mekEnergyStorage)) {
            return this.canOutputEnergy(side);
        }
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap != null && (cap == EnergyUtil.mekCableOutput || cap == EnergyUtil.mekEnergyStorage)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public float getProvide(EnumFacing direction) {
        if (direction == null && EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, this.getElectricOutputDirection());
            if (tile instanceof IConductor) {
                return 0.0f;
            }
            return this.storage.extractEnergyGC(Float.MAX_VALUE, true);
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return this.storage.extractEnergyGC(Float.MAX_VALUE, true);
        }
        return 0.0f;
    }

    public EnumFacing getElectricOutputDirection() {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="cofh.redstoneflux.api.IEnergyProvider", modID="")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (EnergyConfigHandler.disableRFOutput) {
            return 0;
        }
        if (!this.getElectricalOutputDirections().contains(from)) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(this.storage.extractEnergyGC((float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO));
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(this.storage.extractEnergyGC((float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO));
    }

    @Override
    public boolean canExtract() {
        return !EnergyConfigHandler.disableFEOutput;
    }
}

