/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.tile;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.blocks.BlockPanelLighting;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityArclampRenderer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPanelLight;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityPanelLightRenderer
extends TileEntitySpecialRenderer<TileEntityPanelLight> {
    public static final ResourceLocation lampTexture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/misc/underoil.png");
    public static final ResourceLocation lightTexture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/misc/light.png");
    private static OBJModel.OBJBakedModel lampMetal;

    public void render(TileEntityPanelLight tileEntity, double d, double d1, double d2, float f, int par9, float alpha) {
        float frameC;
        float frameB;
        float frameA;
        this.updateModels();
        int side = tileEntity.meta;
        int rot = side >> 3;
        side = side & 7 ^ 1;
        BlockPanelLighting.PanelType type = tileEntity.getType();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)d + 0.5f), (float)((float)d1 + 0.5f), (float)((float)d2 + 0.5f));
        switch (side) {
            case 0: {
                break;
            }
            case 1: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 2: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 3: {
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 4: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                rot = (rot + 1) % 4;
                break;
            }
            case 5: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                rot = (rot + 1) % 4;
            }
        }
        if (rot > 0) {
            GlStateManager.func_179114_b((float)(90.0f * (float)rot), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (type == BlockPanelLighting.PanelType.SFDIAG) {
            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        RenderHelper.func_74518_a();
        if (tileEntity.getEnabled()) {
            ColorUtil.setGLColor(tileEntity.color);
        } else {
            float greyLevel = 0.09411765f;
            GlStateManager.func_179131_c((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        }
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179140_f();
        this.func_147499_a(TileEntityArclampRenderer.lightTexture);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179090_x();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        float frameY = 1.01f;
        switch (type) {
            default: {
                frameA = 0.15f;
                frameB = 0.5f;
                frameC = frameA;
                break;
            }
            case SPOTS: {
                frameA = 0.21f;
                frameB = 0.29f;
                frameC = frameA;
                break;
            }
            case LINEAR: {
                frameA = 0.08f;
                frameB = 0.5f;
                frameC = 0.36f;
                break;
            }
            case SF: 
            case SFDIAG: {
                frameA = 0.1f;
                frameB = 0.4f;
                frameC = 0.35f;
            }
        }
        if (type != BlockPanelLighting.PanelType.SFDIAG) {
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameC).func_181675_d();
            tess.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)(1.0f - frameA), (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)(1.0f - frameB), (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)(1.0f - frameB), (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)(1.0f - frameA), (double)frameY, (double)frameB).func_181675_d();
            tess.func_78381_a();
            frameA = 1.0f - frameA;
            frameB = 1.0f - frameB;
            frameC = 1.0f - frameC;
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameC).func_181675_d();
            tess.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)(1.0f - frameA), (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)(1.0f - frameB), (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)(1.0f - frameB), (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)(1.0f - frameA), (double)frameY, (double)frameB).func_181675_d();
            tess.func_78381_a();
        } else {
            GlStateManager.func_179109_b((float)0.239f, (float)0.0f, (float)-0.345f);
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)(frameA += 0.02f), (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameC).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179109_b((float)0.23f, (float)0.0f, (float)0.233f);
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)(frameA += 0.02f), (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameC).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179109_b((float)-0.48f, (float)0.0f, (float)0.0f);
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameB).func_181675_d();
            worldRenderer.func_181662_b((double)frameB, (double)frameY, (double)frameC).func_181675_d();
            worldRenderer.func_181662_b((double)frameA, (double)frameY, (double)frameC).func_181675_d();
            tess.func_78381_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void updateModels() {
        if (lampMetal == null) {
            try {
                OBJModel model = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(Constants.ASSET_PREFIX, "arclamp_metal.obj"));
                model = (OBJModel)model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                lampMetal = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"main"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

