/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.tile;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import org.lwjgl.opengl.GL11;

public class TileEntityBubbleProviderRenderer<E extends TileEntity>
extends TileEntitySpecialRenderer<E> {
    private static OBJModel.OBJBakedModel sphere;
    private final float colorRed;
    private final float colorGreen;
    private final float colorBlue;

    public TileEntityBubbleProviderRenderer(float colorRed, float colorGreen, float colorBlue) {
        this.colorRed = colorRed;
        this.colorGreen = colorGreen;
        this.colorBlue = colorBlue;
    }

    private static void updateModels() {
        if (sphere == null) {
            try {
                OBJModel model = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(Constants.ASSET_PREFIX, "sphere.obj"));
                model = (OBJModel)model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                sphere = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Sphere"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void func_192841_a(E provider, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!((IBubbleProvider)provider).getBubbleVisible()) {
            return;
        }
        TileEntityBubbleProviderRenderer.updateModels();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        this.func_147499_a(TextureMap.field_110575_b);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)(this.colorRed / 2.0f), (float)(this.colorGreen / 2.0f), (float)(this.colorBlue / 2.0f), (float)1.0f);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glDepthMask((boolean)false);
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glScalef((float)((IBubbleProvider)provider).getBubbleSize(), (float)((IBubbleProvider)provider).getBubbleSize(), (float)((IBubbleProvider)provider).getBubbleSize());
        int color = ColorUtil.to32BitColor(30, (int)(this.colorBlue / 2.0f * 255.0f), (int)(this.colorGreen / 2.0f * 255.0f), (int)(this.colorRed / 2.0f * 255.0f));
        ClientUtil.drawBakedModelColored((IBakedModel)sphere, color);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glMatrixMode((int)5890);
        GL11.glDepthMask((boolean)true);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2884);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

