/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import api.player.server.ServerPlayerAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.client.gui.GuiHandler;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenBasic;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenCelestial;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenText;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.command.CommandGCEnergyUnits;
import micdoodle8.mods.galacticraft.core.command.CommandGCHelp;
import micdoodle8.mods.galacticraft.core.command.CommandGCInv;
import micdoodle8.mods.galacticraft.core.command.CommandJoinSpaceRace;
import micdoodle8.mods.galacticraft.core.command.CommandKeepDim;
import micdoodle8.mods.galacticraft.core.command.CommandPlanetTeleport;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationAddOwner;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationChangeOwner;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationRemoveOwner;
import micdoodle8.mods.galacticraft.core.dimension.GCDimensions;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeMoon;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOrbit;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOverworld;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOverworldOrbit;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.grid.ChunkPowerHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.TileCableIC2Sealed;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityFlag;
import micdoodle8.mods.galacticraft.core.entities.EntityHangingSchematic;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.EntityTier1Rocket;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerBaseMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.event.LootHandlerGC;
import micdoodle8.mods.galacticraft.core.items.ItemSchematic;
import micdoodle8.mods.galacticraft.core.network.ConnectionEvents;
import micdoodle8.mods.galacticraft.core.network.ConnectionPacket;
import micdoodle8.mods.galacticraft.core.network.GalacticraftChannelHandler;
import micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.recipe.RecipeManagerGC;
import micdoodle8.mods.galacticraft.core.schematic.SchematicAdd;
import micdoodle8.mods.galacticraft.core.schematic.SchematicMoonBuggy;
import micdoodle8.mods.galacticraft.core.schematic.SchematicRocketT1;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWireSwitch;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFueler;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFuelerSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCrafting;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDeconstructor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFallenMeteor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNasaWorkbench;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNull;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDecompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPainter;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPanelLight;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPlayerDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySpaceStationBase;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.tile.TileEntityThruster;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.ThreadRequirementMissing;
import micdoodle8.mods.galacticraft.core.util.ThreadVersionCheck;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeMoon;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeOrbit;
import micdoodle8.mods.galacticraft.core.world.gen.OreGenOtherMods;
import micdoodle8.mods.galacticraft.core.world.gen.OverworldGenerator;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod(modid="galacticraftcore", name="Galacticraft Core", version="4.0.1.131", useMetadata=true, acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.1.2555,); required-after:micdoodlecore; after:ic2; after:tconstruct; after:mantle;", guiFactory="micdoodle8.mods.galacticraft.core.client.gui.screen.ConfigGuiFactoryCore")
public class GalacticraftCore {
    public static final String NAME = "Galacticraft Core";
    private File GCCoreSource;
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore", serverSide="micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore")
    public static CommonProxyCore proxy;
    @Mod.Instance(value="galacticraftcore")
    public static GalacticraftCore instance;
    public static boolean isPlanetsLoaded;
    public static boolean isHeightConflictingModInstalled;
    public static GalacticraftChannelHandler packetPipeline;
    public static GCPlayerHandler handler;
    public static CreativeTabGC galacticraftBlocksTab;
    public static CreativeTabGC galacticraftItemsTab;
    public static SolarSystem solarSystemSol;
    public static Planet planetMercury;
    public static Planet planetVenus;
    public static Planet planetMars;
    public static Planet planetOverworld;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Moon moonMoon;
    public static Satellite satelliteSpaceStation;
    public static LinkedList<ItemStack> itemList;
    public static LinkedList<Item> itemListTrue;
    public static LinkedList<Block> blocksList;
    public static LinkedList<BiomeGenBaseGC> biomesList;
    public static ImageWriter jpgWriter;
    public static ImageWriteParam writeParam;
    public static boolean enableJPEG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.GCCoreSource = event.getSourceFile();
        GCCapabilities.register();
        this.initModInfo(event.getModMetadata());
        isPlanetsLoaded = Loader.isModLoaded((String)"galacticraftplanets");
        GCCoreUtil.nextID = 0;
        if (CompatibilityManager.isSmartMovingLoaded || CompatibilityManager.isWitcheryLoaded) {
            isHeightConflictingModInstalled = true;
        }
        solarSystemSol = new SolarSystem("sol", "milky_way").setMapPosition(new Vector3(0.0, 0.0, 0.0));
        planetOverworld = (Planet)new Planet("overworld").setParentSolarSystem(solarSystemSol).setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(0.0f);
        moonMoon = (Moon)new Moon("moon").setParentPlanet(planetOverworld).setRelativeSize(0.2667f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(13.0f, 13.0f)).setRelativeOrbitTime(100.0f);
        satelliteSpaceStation = (Satellite)new Satellite("spacestation.overworld").setParentBody(planetOverworld).setRelativeSize(0.2667f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f)).setRelativeOrbitTime(20.0f);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerGC());
        handler = new GCPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        proxy.preInit(event);
        ConnectionPacket.bus = NetworkRegistry.INSTANCE.newEventDrivenChannel("galacticraft");
        ConnectionPacket.bus.register((Object)new ConnectionPacket());
        ConfigManagerCore.initialize(new File(event.getModConfigurationDirectory(), "Galacticraft/core.conf"));
        EnergyConfigHandler.setDefaultValues(new File(event.getModConfigurationDirectory(), "Galacticraft/power-GC3.conf"));
        ChunkLoadingCallback.loadConfig(new File(event.getModConfigurationDirectory(), "Galacticraft/chunkloading.conf"));
        galacticraftBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "galacticraft_blocks", null, null);
        galacticraftItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "galacticraft_items", null, null);
        GCFluids.registerOilandFuel();
        if (CompatibilityManager.PlayerAPILoaded) {
            ServerPlayerAPI.register((String)"galacticraftcore", GCPlayerBaseMP.class);
        }
        GCBlocks.initBlocks();
        GCItems.initItems();
        GCFluids.registerFluids();
        satelliteSpaceStation.setBiomeInfo(BiomeOrbit.space);
        moonMoon.setBiomeInfo(BiomeMoon.moonFlat);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        galacticraftBlocksTab.setItemForTab(new ItemStack(Item.func_150898_a((Block)GCBlocks.machineBase2)));
        galacticraftItemsTab.setItemForTab(new ItemStack(GCItems.rocketTier1));
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GCBlocks.finalizeSort();
            GCItems.finalizeSort();
        }
        proxy.init(event);
        packetPipeline = GalacticraftChannelHandler.init();
        Star starSol = (Star)new Star("sol").setParentSolarSystem(solarSystemSol).setTierRequired(-1);
        starSol.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/sun.png"));
        solarSystemSol.setMainStar(starSol);
        planetOverworld.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png"));
        planetOverworld.setDimensionInfo(ConfigManagerCore.idDimensionOverworld, WorldProvider.class, false).setTierRequired(1);
        planetOverworld.atmosphereComponent(EnumAtmosphericGas.NITROGEN).atmosphereComponent(EnumAtmosphericGas.OXYGEN).atmosphereComponent(EnumAtmosphericGas.ARGON).atmosphereComponent(EnumAtmosphericGas.WATER);
        planetOverworld.addChecklistKeys("equipParachute");
        moonMoon.setDimensionInfo(ConfigManagerCore.idDimensionMoon, WorldProviderMoon.class).setTierRequired(1);
        moonMoon.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/moon.png"));
        moonMoon.setAtmosphere(new AtmosphereInfo(false, false, false, 0.0f, 0.0f, 0.0f));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        moonMoon.addChecklistKeys("equipOxygenSuit");
        satelliteSpaceStation.setDimensionInfo(ConfigManagerCore.idDimensionOverworldOrbit, ConfigManagerCore.idDimensionOverworldOrbitStatic, WorldProviderOverworldOrbit.class).setTierRequired(1);
        satelliteSpaceStation.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/space_station.png"));
        satelliteSpaceStation.setAtmosphere(new AtmosphereInfo(false, false, false, 0.0f, 0.1f, 0.02f));
        satelliteSpaceStation.addChecklistKeys("equipOxygenSuit", "createGrapple");
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
        MinecraftForge.EVENT_BUS.register((Object)new ConnectionEvents());
        SchematicRegistry.registerSchematicRecipe(new SchematicRocketT1());
        SchematicRegistry.registerSchematicRecipe(new SchematicMoonBuggy());
        SchematicRegistry.registerSchematicRecipe(new SchematicAdd());
        ChunkPowerHandler.initiate();
        EnergyConfigHandler.initGas();
        LootHandlerGC.registerAll();
        this.registerCreatures();
        this.registerOtherEntities();
        this.registerTileEntities();
        GalaxyRegistry.registerSolarSystem(solarSystemSol);
        GalaxyRegistry.registerPlanet(planetOverworld);
        GalaxyRegistry.registerMoon(moonMoon);
        GalaxyRegistry.registerSatellite(satelliteSpaceStation);
        GCDimensions.ORBIT = GalacticraftRegistry.registerDimension("Space Station", "_orbit", ConfigManagerCore.idDimensionOverworldOrbit, WorldProviderOverworldOrbit.class, false);
        if (GCDimensions.ORBIT == null) {
            GCLog.severe("Failed to register space station dimension type with ID " + ConfigManagerCore.idDimensionOverworldOrbit);
        }
        if ((GCDimensions.ORBIT_KEEPLOADED = GalacticraftRegistry.registerDimension("Space Station", "_orbit", ConfigManagerCore.idDimensionOverworldOrbitStatic, WorldProviderOverworldOrbit.class, true)) == null) {
            GCLog.severe("Failed to register space station dimension type with ID " + ConfigManagerCore.idDimensionOverworldOrbitStatic);
        }
        GalacticraftRegistry.registerTeleportType(WorldProviderSurface.class, new TeleportTypeOverworld());
        GalacticraftRegistry.registerTeleportType(WorldProviderOverworldOrbit.class, new TeleportTypeOrbit());
        GalacticraftRegistry.registerTeleportType(WorldProviderMoon.class, new TeleportTypeMoon());
        GalacticraftRegistry.registerRocketGui(WorldProviderOverworldOrbit.class, new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/overworld_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderSurface.class, new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/overworld_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderMoon.class, new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/moon_rocket_gui.png"));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCItems.schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCItems.schematic, 1, 1));
        if (ConfigManagerCore.enableCopperOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 5, 24, 0, 75, 7), (int)4);
        }
        if (ConfigManagerCore.enableTinOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 6, 22, 0, 60, 7), (int)4);
        }
        if (ConfigManagerCore.enableAluminumOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 7, 18, 0, 45, 7), (int)4);
        }
        if (ConfigManagerCore.enableSiliconOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 8, 3, 0, 25, 7), (int)4);
        }
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.patreon.com/micdoodle8");
        GalacticraftCore.registerCoreGameScreens();
        GCFluids.registerLegacyFluids();
        GalacticraftRegistry.registerGear(0, EnumExtendedInventorySlot.MASK, GCItems.oxMask);
        GalacticraftRegistry.registerGear(1, EnumExtendedInventorySlot.GEAR, GCItems.oxygenGear);
        GalacticraftRegistry.registerGear(2, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxTankLight);
        GalacticraftRegistry.registerGear(2, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxTankLight);
        GalacticraftRegistry.registerGear(3, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxTankMedium);
        GalacticraftRegistry.registerGear(3, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxTankMedium);
        GalacticraftRegistry.registerGear(4, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxTankHeavy);
        GalacticraftRegistry.registerGear(4, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxTankHeavy);
        GalacticraftRegistry.registerGear(5, EnumExtendedInventorySlot.LEFT_TANK, GCItems.oxygenCanisterInfinite);
        GalacticraftRegistry.registerGear(5, EnumExtendedInventorySlot.RIGHT_TANK, GCItems.oxygenCanisterInfinite);
        GalacticraftRegistry.registerGear(14, EnumExtendedInventorySlot.PARACHUTE, GCItems.parachute);
        GalacticraftRegistry.registerGear(15, EnumExtendedInventorySlot.FREQUENCY_MODULE, new ItemStack(GCItems.basicItem, 1, 19));
        proxy.registerFluidTexture(GCFluids.fluidOil, new ResourceLocation(Constants.ASSET_PREFIX, "textures/misc/underoil.png"));
        proxy.registerFluidTexture(GCFluids.fluidFuel, new ResourceLocation(Constants.ASSET_PREFIX, "textures/misc/underfuel.png"));
        PermissionAPI.registerNode((String)"galacticraft.station.create", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allows players to create space stations");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        planetMercury = this.makeDummyPlanet("mercury", solarSystemSol);
        if (planetMercury != null) {
            planetMercury.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(0.24096386f);
        }
        if ((planetVenus = this.makeDummyPlanet("venus", solarSystemSol)) != null) {
            planetVenus.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.0f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f)).setRelativeOrbitTime(0.6152793f);
        }
        if ((planetMars = this.makeDummyPlanet("mars", solarSystemSol)) != null) {
            planetMars.setRingColorRGB(0.67f, 0.1f, 0.1f).setPhaseShift(0.1667f).setRelativeSize(0.5319f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.25f, 1.25f)).setRelativeOrbitTime(1.881161f);
        }
        if ((planetJupiter = this.makeDummyPlanet("jupiter", solarSystemSol)) != null) {
            planetJupiter.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift((float)Math.PI).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f)).setRelativeOrbitTime(11.861994f);
        }
        if ((planetSaturn = this.makeDummyPlanet("saturn", solarSystemSol)) != null) {
            planetSaturn.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f)).setRelativeOrbitTime(29.463308f);
        }
        if ((planetUranus = this.makeDummyPlanet("uranus", solarSystemSol)) != null) {
            planetUranus.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.38f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f)).setRelativeOrbitTime(84.06353f);
        }
        if ((planetNeptune = this.makeDummyPlanet("neptune", solarSystemSol)) != null) {
            planetNeptune.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.0f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.25f, 2.25f)).setRelativeOrbitTime(164.84119f);
        }
        MinecraftForge.EVENT_BUS.register((Object)new OreGenOtherMods());
        proxy.postInit(event);
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (body.shouldAutoRegister()) {
                int id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, body.getDimensionID());
                DimensionType type = GalacticraftRegistry.registerDimension(body.getLocalizedName(), body.getDimensionSuffix(), body.getDimensionID(), body.getWorldProvider(), body.getForceStaticLoad() || id < 0);
                if (type != null) {
                    body.initialiseMobSpawns();
                } else {
                    body.setUnreachable();
                    GCLog.severe("Tried to register dimension for body: " + body.getLocalizedName() + " hit conflict with ID " + body.getDimensionID());
                }
            }
            if (body.getSurfaceBlocks() == null) continue;
            TransformerHooks.spawnListAE2_GC.addAll(body.getSurfaceBlocks());
        }
        GCDimensions.MOON = WorldUtil.getDimensionTypeById(ConfigManagerCore.idDimensionMoon);
        CompatibilityManager.checkForCompatibleMods();
        RecipeManagerGC.loadCompatibilityRecipes();
        TileEntityDeconstructor.initialiseRecipeList();
        ItemSchematic.registerSchematicItems();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerServer());
        GalaxyRegistry.refreshGalaxies();
        GalacticraftRegistry.registerScreen(new GameScreenText());
        try {
            jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            writeParam = jpgWriter.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setCompressionQuality(1.0f);
            enableJPEG = true;
        }
        catch (UnsatisfiedLinkError e) {
            GCLog.severe("Error initialising JPEG compressor - this is likely caused by OpenJDK - see https://wiki.micdoodle8.com/wiki/Compatibility#For_clients_running_OpenJDK");
            e.printStackTrace();
        }
        if (event.getSide() == Side.SERVER) {
            this.loadLanguageCore("en_US");
        }
    }

    public void loadLanguageCore(String lang) {
        GCCoreUtil.loadLanguage(lang, Constants.ASSET_PREFIX, this.GCCoreSource);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        TickHandlerServer.restart();
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        if (ThreadRequirementMissing.INSTANCE == null) {
            ThreadRequirementMissing.beginCheck(GCCoreUtil.getEffectiveSide());
        }
        ThreadVersionCheck.startCheck();
        BlockVec3.chunkCacheDim = Integer.MAX_VALUE;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSpaceStationAddOwner());
        event.registerServerCommand((ICommand)new CommandSpaceStationChangeOwner());
        event.registerServerCommand((ICommand)new CommandSpaceStationRemoveOwner());
        event.registerServerCommand((ICommand)new CommandPlanetTeleport());
        event.registerServerCommand((ICommand)new CommandKeepDim());
        event.registerServerCommand((ICommand)new CommandGCInv());
        event.registerServerCommand((ICommand)new CommandGCHelp());
        event.registerServerCommand((ICommand)new CommandGCEnergyUnits());
        event.registerServerCommand((ICommand)new CommandJoinSpaceRace());
        WorldUtil.initialiseDimensionNames();
        WorldUtil.registerSpaceStations(event.getServer().func_71218_a(0).func_72860_G().func_75758_b("dummy").getParentFile());
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!body.shouldAutoRegister() || WorldUtil.registerPlanet(body.getDimensionID(), body.getReachable(), 0)) continue;
            body.setUnreachable();
        }
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppedEvent var1) {
        WorldUtil.unregisterPlanets();
        WorldUtil.unregisterSpaceStations();
        MapUtil.saveMapProgress();
    }

    private static void registerCoreGameScreens() {
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            GameScreenBasic rendererBasic = new GameScreenBasic();
            GameScreenCelestial rendererCelest = new GameScreenCelestial();
            GalacticraftRegistry.registerScreen(rendererBasic);
            GalacticraftRegistry.registerScreen(rendererBasic);
            GalacticraftRegistry.registerScreen(rendererCelest);
            GalacticraftRegistry.registerScreen(rendererCelest);
            GalacticraftRegistry.registerScreen(rendererCelest);
        } else {
            GalacticraftRegistry.registerScreensServer(5);
        }
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityTreasureChest.class, (String)"GC Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityOxygenDistributor.class, (String)"GC Air Distributor");
        GameRegistry.registerTileEntity(TileEntityOxygenCollector.class, (String)"GC Air Collector");
        GameRegistry.registerTileEntity(TileEntityFluidPipe.class, (String)"GC Oxygen Pipe");
        GameRegistry.registerTileEntity(TileEntityAirLock.class, (String)"GC Air Lock Frame");
        GameRegistry.registerTileEntity(TileEntityRefinery.class, (String)"GC Refinery");
        GameRegistry.registerTileEntity(TileEntityNasaWorkbench.class, (String)"GC NASA Workbench");
        GameRegistry.registerTileEntity(TileEntityDeconstructor.class, (String)"GC Deconstructor");
        GameRegistry.registerTileEntity(TileEntityOxygenCompressor.class, (String)"GC Air Compressor");
        GameRegistry.registerTileEntity(TileEntityFuelLoader.class, (String)"GC Fuel Loader");
        GameRegistry.registerTileEntity(TileEntityLandingPadSingle.class, (String)"GC Landing Pad");
        GameRegistry.registerTileEntity(TileEntityLandingPad.class, (String)"GC Landing Pad Full");
        GameRegistry.registerTileEntity(TileEntitySpaceStationBase.class, (String)"GC Space Station");
        GameRegistry.registerTileEntity(TileEntityMulti.class, (String)"GC Dummy Block");
        GameRegistry.registerTileEntity(TileEntityOxygenSealer.class, (String)"GC Air Sealer");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawner.class, (String)"GC Dungeon Boss Spawner");
        GameRegistry.registerTileEntity(TileEntityOxygenDetector.class, (String)"GC Oxygen Detector");
        GameRegistry.registerTileEntity(TileEntityBuggyFueler.class, (String)"GC Buggy Fueler");
        GameRegistry.registerTileEntity(TileEntityBuggyFuelerSingle.class, (String)"GC Buggy Fueler Single");
        GameRegistry.registerTileEntity(TileEntityCargoLoader.class, (String)"GC Cargo Loader");
        GameRegistry.registerTileEntity(TileEntityCargoUnloader.class, (String)"GC Cargo Unloader");
        GameRegistry.registerTileEntity(TileEntityParaChest.class, (String)"GC Parachest Tile");
        GameRegistry.registerTileEntity(TileEntitySolar.class, (String)"GC Solar Panel");
        GameRegistry.registerTileEntity(TileEntityDish.class, (String)"GC Radio Telescope");
        GameRegistry.registerTileEntity(TileEntityCrafting.class, (String)"GC Magnetic Crafting Table");
        GameRegistry.registerTileEntity(TileEntityEnergyStorageModule.class, (String)"GC Energy Storage Module");
        GameRegistry.registerTileEntity(TileEntityCoalGenerator.class, (String)"GC Coal Generator");
        GameRegistry.registerTileEntity(TileEntityElectricFurnace.class, (String)"GC Electric Furnace");
        GameRegistry.registerTileEntity(TileEntityAluminumWire.class, (String)"GC Aluminum Wire");
        GameRegistry.registerTileEntity(TileEntityAluminumWireSwitch.class, (String)"GC Switchable Aluminum Wire");
        GameRegistry.registerTileEntity(TileEntityFallenMeteor.class, (String)"GC Fallen Meteor");
        GameRegistry.registerTileEntity(TileEntityIngotCompressor.class, (String)"GC Ingot Compressor");
        GameRegistry.registerTileEntity(TileEntityElectricIngotCompressor.class, (String)"GC Electric Ingot Compressor");
        GameRegistry.registerTileEntity(TileEntityCircuitFabricator.class, (String)"GC Circuit Fabricator");
        GameRegistry.registerTileEntity(TileEntityAirLockController.class, (String)"GC Air Lock Controller");
        GameRegistry.registerTileEntity(TileEntityOxygenStorageModule.class, (String)"GC Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntityOxygenDecompressor.class, (String)"GC Oxygen Decompressor");
        GameRegistry.registerTileEntity(TileEntityThruster.class, (String)"GC Space Station Thruster");
        GameRegistry.registerTileEntity(TileEntityArclamp.class, (String)"GC Arc Lamp");
        GameRegistry.registerTileEntity(TileEntityScreen.class, (String)"GC View Screen");
        GameRegistry.registerTileEntity(TileEntityPanelLight.class, (String)"GC Panel Lighting");
        GameRegistry.registerTileEntity(TileEntityTelemetry.class, (String)"GC Telemetry Unit");
        GameRegistry.registerTileEntity(TileEntityPainter.class, (String)"GC Painter");
        GameRegistry.registerTileEntity(TileEntityFluidTank.class, (String)"GC Fluid Tank");
        GameRegistry.registerTileEntity(TileEntityPlayerDetector.class, (String)"GC Player Detector");
        GameRegistry.registerTileEntity(TileEntityNull.class, (String)"GC Null Tile");
        if (CompatibilityManager.isIc2Loaded()) {
            GameRegistry.registerTileEntity(TileCableIC2Sealed.class, (String)"GC Sealed IC2 Cable");
        }
    }

    private void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedSpider.class, "evolved_spider", 3419431, 11013646);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedZombie.class, "evolved_zombie", 44975, 7969893);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedCreeper.class, "evolved_creeper", 894731, 0);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedSkeleton.class, "evolved_skeleton", 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(EntitySkeletonBoss.class, "evolved_skeleton_boss", 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(EntityAlienVillager.class, "alien_villager", ColorUtil.to32BitColor(255, 103, 145, 181), 12422002);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedEnderman.class, "evolved_enderman", 0x161616, 0);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedWitch.class, "evolved_witch", 0x340000, 5349438);
    }

    private void registerOtherEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier1Rocket.class, "rocket_t1", 150, 1, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMeteor.class, "meteor", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityBuggy.class, "buggy", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityFlag.class, "gcflag", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityParachest.class, "para_chest", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityLander.class, "lander", 150, 5, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMeteorChunk.class, "meteor_chunk", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityCelestialFake.class, "celestial_screen", 150, 5, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityHangingSchematic.class, "hanging_schematic", 150, 5, false);
    }

    private Planet makeDummyPlanet(String name, SolarSystem system) {
        for (CelestialBody celestialBody : new ArrayList<Planet>(GalaxyRegistry.getRegisteredPlanets().values())) {
            if (!(celestialBody instanceof Planet) || !name.equals(celestialBody.getName()) || ((Planet)celestialBody).getParentSolarSystem() != system) continue;
            return null;
        }
        Planet planet = new Planet(name).setParentSolarSystem(system);
        planet.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/" + name + ".png"));
        GalaxyRegistry.registerPlanet(planet);
        return planet;
    }

    private void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = "galacticraftcore";
        info.name = NAME;
        info.version = "4.0.1.131";
        info.description = "An advanced space travel mod for Minecraft!";
        info.url = "https://micdoodle8.com/";
        info.authorList = Arrays.asList("micdoodle8", "radfast", "EzerArch", "fishtaco", "SpaceViking", "SteveKunG");
        info.logoFile = "assets/galacticraftcore/galacticraft_logo.png";
    }

    static {
        itemList = new LinkedList();
        itemListTrue = new LinkedList();
        blocksList = new LinkedList();
        biomesList = new LinkedList();
        enableJPEG = false;
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber(modid="galacticraftcore")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            GCBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
            CompatibilityManager.registerMicroBlocks();
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerBlocksLast(RegistryEvent.Register<Block> event) {
            GCBlocks.doOtherModsTorches((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            GCItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
            if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
                for (Item item : itemListTrue) {
                    GCItems.registerSorted(item);
                }
                for (Block block : blocksList) {
                    GCBlocks.registerSorted(block);
                }
            }
            GCBlocks.oreDictRegistrations();
            GCItems.oreDictRegistrations();
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerItemsLast(RegistryEvent.Register<Item> event) {
            handler.registerTorchTypes();
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            RecipeManagerGC.addUniversalRecipes();
            RecipeManagerGC.setConfigurableRecipes();
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            proxy.registerVariants();
            if (isPlanetsLoaded) {
                GalacticraftPlanets.proxy.registerVariants();
            }
        }

        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            for (BiomeGenBaseGC biome : biomesList) {
                event.getRegistry().register((IForgeRegistryEntry)biome);
                if (ConfigManagerCore.disableBiomeTypeRegistrations) continue;
                biome.registerTypes(biome);
            }
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
                GCSounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
            }
        }
    }
}

