/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.entities;

import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockBasicVenus;
import micdoodle8.mods.galacticraft.planets.venus.entities.ai.EntityMoveHelperCeiling;
import micdoodle8.mods.galacticraft.planets.venus.entities.ai.PathNavigateCeiling;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityJuicer
extends EntityMob
implements IEntityBreathable {
    private static final DataParameter<Boolean> IS_FALLING = EntityDataManager.func_187226_a(EntityJuicer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HANGING = EntityDataManager.func_187226_a(EntityJuicer.class, (DataSerializer)DataSerializers.field_187198_h);
    private BlockPos jumpTarget;
    private int timeSinceLastJump = 0;

    public EntityJuicer(World world) {
        super(world);
        this.field_70765_h = new EntityMoveHelperCeiling((EntityLiving)this);
        this.func_70105_a(0.95f, 0.6f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.timeSinceLastJump = this.field_70146_Z.nextInt(200) + 50;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_FALLING, (Object)false);
        this.field_70180_af.func_187214_a(IS_HANGING, (Object)false);
    }

    public boolean isHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FALLING);
    }

    public void setHanging(boolean hanging) {
        this.field_70180_af.func_187227_b(IS_FALLING, (Object)hanging);
    }

    public boolean isFalling() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FALLING);
    }

    public void setFalling(boolean falling) {
        this.field_70180_af.func_187227_b(IS_FALLING, (Object)falling);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected float func_70647_i() {
        return super.func_70647_i() + 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public void func_70636_d() {
        if (this.isHanging()) {
            this.field_70122_E = true;
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.jumpTarget == null) {
            if (this.timeSinceLastJump <= 0) {
                IBlockState blockBelow;
                RayTraceResult hit;
                BlockPos posAbove = new BlockPos(this.field_70165_t, this.field_70163_u + (this.isHanging() ? 1.0 : -0.5), this.field_70161_v);
                IBlockState blockAbove = this.field_70170_p.func_180495_p(posAbove);
                if (!(blockAbove.func_177230_c() != VenusBlocks.venusBlock || blockAbove.func_177229_b((IProperty)BlockBasicVenus.BASIC_TYPE_VENUS) != BlockBasicVenus.EnumBlockBasicVenus.DUNGEON_BRICK_2 && blockAbove.func_177229_b((IProperty)BlockBasicVenus.BASIC_TYPE_VENUS) != BlockBasicVenus.EnumBlockBasicVenus.DUNGEON_BRICK_1 || (hit = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(this.field_70165_t, this.field_70163_u + (double)(this.isHanging() ? -10 : 10), this.field_70161_v), false, true, false)) == null || hit.field_72313_a != RayTraceResult.Type.BLOCK || (blockBelow = this.field_70170_p.func_180495_p(hit.func_178782_a())).func_177230_c() != VenusBlocks.venusBlock || blockBelow.func_177229_b((IProperty)BlockBasicVenus.BASIC_TYPE_VENUS) != BlockBasicVenus.EnumBlockBasicVenus.DUNGEON_BRICK_2 && blockBelow.func_177229_b((IProperty)BlockBasicVenus.BASIC_TYPE_VENUS) != BlockBasicVenus.EnumBlockBasicVenus.DUNGEON_BRICK_1)) {
                    if (this.isHanging()) {
                        this.jumpTarget = hit.func_178782_a();
                        this.setFalling(this.jumpTarget != null);
                    } else {
                        this.jumpTarget = hit.func_178782_a().func_177972_a(EnumFacing.DOWN);
                        this.setFalling(this.jumpTarget != null);
                    }
                }
            } else {
                --this.timeSinceLastJump;
            }
        }
        if (this.isHanging()) {
            this.field_70181_x = 0.0;
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.isHanging()) {
            this.field_70122_E = true;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else if (this.jumpTarget != null) {
            double diffX = (double)this.jumpTarget.func_177958_n() - this.field_70165_t + 0.5;
            double diffY = (double)this.jumpTarget.func_177956_o() - this.field_70163_u + 0.6;
            double diffZ = (double)this.jumpTarget.func_177952_p() - this.field_70161_v + 0.5;
            this.field_70181_x = diffY > 0.0 ? Math.min(diffY / 2.0, (double)0.2123f) : Math.max(diffY / 2.0, (double)-0.2123f);
            this.field_70159_w = diffX > 0.0 ? Math.min(diffX / 2.0, (double)0.2123f) : Math.max(diffX / 2.0, (double)-0.2123f);
            double d = this.field_70179_y = diffZ > 0.0 ? Math.min(diffZ / 2.0, (double)0.2123f) : Math.max(diffZ / 2.0, (double)-0.2123f);
            if (diffY > 0.0 && Math.abs((double)this.jumpTarget.func_177956_o() - (this.field_70163_u + this.field_70181_x)) < (double)0.4f) {
                this.func_70107_b((double)this.jumpTarget.func_177958_n() + 0.5, (double)this.jumpTarget.func_177956_o() + 0.2, (double)this.jumpTarget.func_177952_p() + 0.5);
                this.jumpTarget = null;
                this.setFalling(false);
                this.timeSinceLastJump = this.field_70146_Z.nextInt(180) + 60;
                this.setHanging(true);
            } else if (diffY < 0.0 && Math.abs((double)this.jumpTarget.func_177956_o() - (this.field_70163_u + this.field_70181_x)) < (double)0.8f) {
                this.func_70107_b((double)this.jumpTarget.func_177958_n() + 0.5, (double)this.jumpTarget.func_177956_o() + 1.0, (double)this.jumpTarget.func_177952_p() + 0.5);
                this.jumpTarget = null;
                this.setFalling(false);
                this.timeSinceLastJump = this.field_70146_Z.nextInt(180) + 60;
                this.setHanging(false);
            } else {
                this.setHanging(false);
            }
        }
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            EntityPlayer var1 = this.field_70170_p.func_72890_a((Entity)this, 5.0);
            return var1 == null;
        }
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean canBreath() {
        return true;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateCeiling(this, worldIn);
    }

    public void func_70110_aj() {
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("timeSinceLastJump", this.timeSinceLastJump);
        tagCompound.func_74757_a("jumpTargetNull", this.jumpTarget == null);
        if (this.jumpTarget != null) {
            tagCompound.func_74768_a("jumpTargetX", this.jumpTarget.func_177958_n());
            tagCompound.func_74768_a("jumpTargetY", this.jumpTarget.func_177956_o());
            tagCompound.func_74768_a("jumpTargetZ", this.jumpTarget.func_177952_p());
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.timeSinceLastJump = tagCompund.func_74762_e("timeSinceLastJump");
        this.jumpTarget = tagCompund.func_74767_n("jumpTargetNull") ? null : new BlockPos(tagCompund.func_74762_e("jumpTargetX"), tagCompund.func_74762_e("jumpTargetY"), tagCompund.func_74762_e("jumpTargetZ"));
        this.setFalling(this.jumpTarget != null);
    }
}

