/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.block.Block;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAstroMiner
extends Item
implements IHoldableItem,
ISortableItem {
    public ItemAstroMiner(String assetName) {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile = null;
        if (playerIn == null) {
            return EnumActionResult.PASS;
        }
        Block id = worldIn.func_180495_p(pos).func_177230_c();
        if (id == GCBlocks.fakeBlock && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityMulti) {
            tile = ((TileEntityMulti)tile).getMainBlockTile();
        }
        if (id == AsteroidBlocks.minerBaseFull) {
            tile = worldIn.func_175625_s(pos);
        }
        if (tile instanceof TileEntityMinerBase) {
            if (worldIn.field_72995_K) {
                ((NetHandlerPlayClient)FMLCommonHandler.instance().getClientPlayHandler()).func_147297_a((Packet)new CPacketPlayerTryUseItemOnBlock(pos, side, hand, hitX, hitY, hitZ));
                return EnumActionResult.FAIL;
            }
            if (worldIn.field_73011_w instanceof WorldProviderSpaceStation) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner7.fail")));
                return EnumActionResult.FAIL;
            }
            if (((TileEntityMinerBase)tile).getLinkedMiner() != null) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner.fail")));
                return EnumActionResult.FAIL;
            }
            if (((TileEntityMinerBase)tile).ticks < 15) {
                return EnumActionResult.FAIL;
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)playerIn;
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerIn);
            int astroCount = stats.getAstroMinerCount();
            if (astroCount >= ConfigManagerAsteroids.astroMinerMax && !playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner2.fail")));
                return EnumActionResult.FAIL;
            }
            if (!((TileEntityMinerBase)tile).spawnMiner(playerMP)) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner1.fail") + " " + GCCoreUtil.translate((String)EntityAstroMiner.blockingBlock.toString())));
                return EnumActionResult.FAIL;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stats.setAstroMinerCount(stats.getAstroMinerCount() + 1);
                playerIn.func_184586_b(hand).func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.GENERAL;
    }
}

