/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.pipe;

import javax.annotation.Nullable;
import mcmultipart.multipart.IMultipart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import pl.asie.charset.api.pipes.IShifter;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.utils.FluidUtils;
import pl.asie.charset.pipes.ModCharsetPipes;
import pl.asie.charset.pipes.pipe.PacketFluidUpdate;
import pl.asie.charset.pipes.pipe.PartPipe;

public class PipeFluidContainer
implements ITickable {
    private static boolean CAN_BE_DRAINED = false;
    public static final int TANK_RATE = 80;
    final Tank[] tanks = new Tank[7];
    FluidStack fluidStack;
    int fluidColor;
    boolean fluidDirty;
    private static final int TANK_SIZE = 250;
    private final PartPipe owner;

    public PipeFluidContainer(PartPipe owner) {
        this.owner = owner;
        for (int i = 0; i < 7; ++i) {
            this.tanks[i] = new Tank(i < 6 ? EnumFacing.func_82600_a((int)i) : null);
        }
    }

    public void onRemoval() {
        int total = 0;
        for (Tank t : this.tanks) {
            total += t.amount;
        }
        if (total == 0) {
            this.fluidStack = null;
            this.fluidDirty = true;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.fluidStack != null) {
            this.fluidStack.writeToNBT(nbt);
            int[] amt = new int[7];
            for (int i = 0; i <= 6; ++i) {
                amt[i] = this.tanks[i].amount;
            }
            nbt.func_74783_a("TankAmts", amt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        int[] amt;
        this.fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        this.fluidDirty = true;
        for (int i = 0; i <= 6; ++i) {
            this.tanks[i].amount = 0;
            this.tanks[i].dirty = true;
        }
        if (this.fluidStack != null && (amt = nbt.func_74759_k("TankAmts")) != null && amt.length == 7) {
            for (int i = 0; i <= 6; ++i) {
                this.tanks[i].amount = Math.min(250, amt[i]);
            }
        }
    }

    public void func_73660_a() {
        if (this.owner.getWorld() == null || this.owner.getWorld().field_72995_K) {
            return;
        }
        if (this.fluidStack == null) {
            return;
        }
        EnumFacing pushDir = null;
        int shifterDist = Integer.MAX_VALUE;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.owner.connects(facing)) {
                IShifter s;
                int sStr = this.owner.getShifterStrength(facing);
                if (sStr <= 0 || sStr >= shifterDist || (s = this.owner.getNearestShifter(facing)) == null || !s.isShifting() || !s.matches(this.fluidStack)) continue;
                pushDir = facing;
                shifterDist = sStr;
                continue;
            }
            this.tanks[facing.ordinal()].amount = 0;
        }
        CAN_BE_DRAINED = true;
        if (pushDir != null) {
            this.pushAll(pushDir);
        } else if (this.owner.connects(EnumFacing.DOWN)) {
            this.pushAll(EnumFacing.DOWN);
        }
        CAN_BE_DRAINED = false;
        this.checkPacketUpdate();
    }

    void sendPacket(boolean ignoreDirty) {
        if (this.owner.getWorld() != null && !this.owner.getWorld().field_72995_K) {
            ModCharsetPipes.packet.sendToAllAround((Packet)new PacketFluidUpdate((IMultipart)this.owner, this, ignoreDirty), (IMultipart)this.owner, 64.0);
        }
    }

    private void checkPacketUpdate() {
        if (this.fluidDirty) {
            if (this.owner.getWorld() != null && !this.owner.getWorld().field_72995_K) {
                this.sendPacket(false);
            }
            return;
        }
        for (int i = 0; i <= 6; ++i) {
            if (!this.tanks[i].isDirty()) continue;
            if (this.owner.getWorld() != null && !this.owner.getWorld().field_72995_K) {
                this.sendPacket(false);
            }
            return;
        }
    }

    private void pushAll(EnumFacing pushDir) {
        FluidUtils.push((IFluidHandler)this.tanks[pushDir.ordinal()], this.getTankBlockNeighbor(this.owner.getPos(), pushDir), 80);
        FluidUtils.push((IFluidHandler)this.tanks[6], (IFluidHandler)this.tanks[pushDir.ordinal()], 80);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing == pushDir || !this.owner.connects(facing)) continue;
            FluidUtils.push((IFluidHandler)this.tanks[facing.ordinal()], (IFluidHandler)this.tanks[6], 80);
        }
    }

    public IFluidHandler getTankBlockNeighbor(BlockPos pos, EnumFacing direction) {
        BlockPos p = pos.func_177972_a(direction);
        TileEntity tile = this.owner.getWorld().func_175625_s(p);
        return FluidUtils.getFluidHandler(tile, direction.func_176734_d());
    }

    public class Tank
    implements IFluidHandler {
        public final EnumFacing location;
        public int amount;
        private boolean dirty;

        public Tank(EnumFacing location) {
            this.location = location;
        }

        public FluidStack getType() {
            return PipeFluidContainer.this.fluidStack;
        }

        public int get() {
            return this.amount;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean removeDirty() {
            if (this.dirty) {
                this.dirty = false;
                return true;
            }
            return false;
        }

        public int add(int amount, boolean simulate) {
            int targetAmount = Math.min(amount, 250 - this.amount);
            if (!simulate && targetAmount > 0) {
                this.amount += targetAmount;
                this.dirty = true;
            }
            return targetAmount;
        }

        public int remove(int amount, boolean simulate) {
            int targetAmount = Math.min(this.amount, amount);
            if (!simulate && targetAmount > 0) {
                this.amount -= targetAmount;
                this.dirty = true;
                PipeFluidContainer.this.onRemoval();
            }
            return targetAmount;
        }

        public FluidTankInfo getInfo() {
            FluidStack stack = this.getType().copy();
            stack.amount = this.amount;
            return new FluidTankInfo(stack, this.getCapacity());
        }

        public int getCapacity() {
            return 250;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new Properties(PipeFluidContainer.this.fluidStack, this.amount, 250)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount == 0) {
                return 0;
            }
            if (PipeFluidContainer.this.fluidStack == null) {
                if (doFill) {
                    PipeFluidContainer.this.fluidStack = resource.copy();
                    PipeFluidContainer.this.fluidDirty = true;
                }
            } else if (!PipeFluidContainer.this.fluidStack.isFluidEqual(resource)) {
                return 0;
            }
            return this.add(resource.amount, !doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount == 0) {
                return null;
            }
            if (CAN_BE_DRAINED) {
                return PipeFluidContainer.this.fluidStack != null && resource.isFluidEqual(PipeFluidContainer.this.fluidStack) ? this.drain(resource.amount, doDrain) : null;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (PipeFluidContainer.this.fluidStack == null) {
                return null;
            }
            if (CAN_BE_DRAINED && maxDrain > 0) {
                FluidStack stack = PipeFluidContainer.this.fluidStack.copy();
                int r = this.remove(maxDrain, !doDrain);
                if (r <= 0) {
                    return null;
                }
                stack.amount = r;
                return stack;
            }
            return null;
        }
    }

    public class Properties
    implements IFluidTankProperties {
        private final FluidStack stack;
        private final int capacity;

        public Properties(FluidStack stack, int amount, int capacity) {
            if (stack != null) {
                this.stack = stack.copy();
                this.stack.amount = amount;
            } else {
                this.stack = null;
            }
            this.capacity = capacity;
        }

        @Nullable
        public FluidStack getContents() {
            return this.stack;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public boolean canFill() {
            return this.stack == null || this.stack.amount < this.capacity;
        }

        public boolean canDrain() {
            return CAN_BE_DRAINED && this.stack != null && this.stack.amount > 0;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return this.stack == null || this.stack.amount < this.capacity && this.stack.isFluidEqual(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return CAN_BE_DRAINED && this.stack != null && this.stack.amount > 0 && this.stack.isFluidEqual(fluidStack);
        }
    }
}

