/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerUtils {
    public static boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer || !player.field_70175_ag;
    }

    public static EntityPlayer find(MinecraftServer server, String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && server == null) {
            if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null) {
                return Minecraft.func_71410_x().field_71441_e.func_72924_a(name);
            }
            return null;
        }
        for (EntityPlayerMP target : server.func_184103_al().func_181057_v()) {
            if (!target.func_70005_c_().equals(name)) continue;
            return target;
        }
        return null;
    }

    public static boolean isCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d;
    }

    public static int getPuntStrengthOrWeakness(EntityPlayer player) {
        if (player == null) {
            return 1;
        }
        int strength = 0;
        PotionEffect p_str = player.func_70660_b(MobEffects.field_76420_g);
        PotionEffect p_wea = player.func_70660_b(MobEffects.field_76437_t);
        if (p_str != null) {
            strength += p_str.func_76458_c() + 1;
        }
        if (p_wea != null) {
            strength -= p_wea.func_76458_c() + 1;
        }
        int knockback = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
        return strength * knockback;
    }

    public static int getPuntStrengthInt(EntityPlayer player) {
        int str = PlayerUtils.getPuntStrengthOrWeakness(player);
        return Math.min(1, str);
    }

    public static double getPuntStrengthMultiplier(EntityPlayer player) {
        int str = PlayerUtils.getPuntStrengthOrWeakness(player);
        if (str == 0) {
            return 1.0;
        }
        if (str < 1) {
            return 1.0 / (double)(-str);
        }
        return str;
    }
}

