/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ColorUtils {
    private static final int[] WOOL_TO_RGB = new int[]{0xFAFAFA, 14188339, 11685080, 6724056, 0xE5E533, 8375321, 15892389, 0x4C4C4C, 0x999999, 5013401, 8339378, 3361970, 6704179, 6717235, 0x993333, 0x191919};
    private static final String[] UPPERCASE_DYE_SUFFIXES = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    private static final String[] LOWERCASE_DYE_SUFFIXES = new String[]{"white", "orange", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "lightGray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final int[] OREDICT_DYE_IDS = new int[16];
    private static final char[] WOOL_TO_CHAT = new char[]{'f', '6', 'd', '9', 'e', 'a', 'd', '8', '7', '3', '5', '1', '6', '2', '4', '0'};

    private ColorUtils() {
    }

    public static void init() {
        for (int i = 0; i < 16; ++i) {
            ColorUtils.OREDICT_DYE_IDS[i] = OreDictionary.getOreID((String)("dye" + UPPERCASE_DYE_SUFFIXES[i]));
        }
    }

    public static int getColorIDFromDye(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return -1;
        }
        if (stack.func_77973_b() == Items.field_151100_aR) {
            return 15 - stack.func_77952_i();
        }
        int[] itemOreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (int i = 0; i < 16; ++i) {
            for (int id : itemOreIDs) {
                if (OREDICT_DYE_IDS[i] != id) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        return ColorUtils.getColorIDFromDye(stack) >= 0;
    }

    public static int getRGBColor(int wool) {
        return WOOL_TO_RGB[wool & 0xF];
    }

    public static String getOreDictEntry(String prefix, int wool) {
        return prefix + UPPERCASE_DYE_SUFFIXES[wool & 0xF];
    }

    public static String getLangEntry(String prefix, int wool) {
        return prefix + LOWERCASE_DYE_SUFFIXES[wool & 0xF];
    }

    public static String ampersandToColor(String chat) {
        return chat.replaceAll("&(?=[0-9A-FK-ORa-fk-or])", "\u00a7");
    }

    public static String stripColor(String chat) {
        return chat.replaceAll("[&\u00a7][0-9A-FK-ORa-fk-or]", "");
    }
}

