/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import pl.asie.charset.lib.recipe.IRecipeObject;
import pl.asie.charset.lib.recipe.IRecipeResult;
import pl.asie.charset.lib.recipe.RecipeBase;
import pl.asie.charset.lib.recipe.RecipeObjectItemStack;
import pl.asie.charset.lib.recipe.RecipeObjectOreDict;

public class RecipeCharset
extends RecipeBase {
    protected IRecipeObject[] input = null;
    protected IRecipeResult output;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = false;
    protected boolean shapeless = false;

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (this.shapeless) {
            HashSet objectSet = new HashSet();
            Collections.addAll(objectSet, this.input);
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                for (int x = 0; x < inv.func_174922_i(); ++x) {
                    ItemStack stack = inv.func_70463_b(x, y);
                    if (stack == null) continue;
                    boolean matches = false;
                    for (IRecipeObject o : objectSet) {
                        if (!o.matches(stack)) continue;
                        matches = true;
                        objectSet.remove(o);
                        break;
                    }
                    if (matches) continue;
                    return false;
                }
            }
            return objectSet.size() == 0;
        }
        for (int yo = 0; yo <= inv.func_174923_h() - this.height; ++yo) {
            for (int xo = 0; xo <= inv.func_174922_i() - this.width; ++xo) {
                boolean noMatch = false;
                for (int i = 0; i < this.input.length; ++i) {
                    IRecipeObject ro = this.input[i];
                    int x = i % this.width + xo;
                    int y = i / this.width + yo;
                    if (ro == null) {
                        if (inv.func_70463_b(x, y) != null) {
                            noMatch = true;
                        }
                    } else if (!ro.matches(inv.func_70463_b(x, y))) {
                        noMatch = true;
                    }
                    if (noMatch) break;
                }
                if (noMatch) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (!this.func_77569_a(inv, null)) {
            return null;
        }
        return (ItemStack)this.output.apply(inv);
    }

    @Override
    public int func_77570_a() {
        return this.input.length;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return null;
    }

    public static class Builder {
        private RecipeCharset recipe;

        private static IRecipeObject toRecipeObject(Object o) {
            if (o instanceof IRecipeObject) {
                return (IRecipeObject)o;
            }
            if (o instanceof Block) {
                return new RecipeObjectItemStack((Block)o);
            }
            if (o instanceof Item) {
                return new RecipeObjectItemStack((Item)o);
            }
            if (o instanceof ItemStack) {
                return new RecipeObjectItemStack((ItemStack)o);
            }
            if (o instanceof String) {
                return new RecipeObjectOreDict((String)o);
            }
            throw new RuntimeException("Invalid recipe object: " + o);
        }

        private static IRecipeObject[] toRecipeObject(Object[] o) {
            IRecipeObject[] objects = new IRecipeObject[o.length];
            for (int i = 0; i < o.length; ++i) {
                objects[i] = Builder.toRecipeObject(o[i]);
            }
            return objects;
        }

        public static Builder create(IRecipeResult output) {
            Builder builder = new Builder();
            builder.recipe = new RecipeCharset();
            builder.recipe.output = output;
            return builder;
        }

        public static Builder create(final ItemStack output) {
            return Builder.create(new IRecipeResult(){

                @Override
                public Object preview() {
                    return output;
                }

                @Nullable
                public ItemStack apply(@Nullable InventoryCrafting input) {
                    return output.func_77946_l();
                }
            });
        }

        public Builder shapeless(Object ... o) {
            this.recipe.shapeless = true;
            this.recipe.input = Builder.toRecipeObject(o);
            return this;
        }

        public Builder shaped(Object ... o) {
            int idx = 0;
            this.recipe.shapeless = false;
            ArrayList<String> shape = new ArrayList<String>();
            ArrayList input = new ArrayList();
            HashMap<Character, IRecipeObject> map = new HashMap<Character, IRecipeObject>();
            while (o[idx] instanceof String) {
                String s = (String)o[idx++];
                shape.add(s);
                this.recipe.width = Math.max(this.recipe.width, s.length());
            }
            this.recipe.height = shape.size();
            map.put(Character.valueOf(' '), null);
            while (idx < o.length) {
                Character c = new Character(((Character)o[idx++]).charValue());
                IRecipeObject ro = Builder.toRecipeObject(o[idx++]);
                map.put(c, ro);
            }
            for (int y = 0; y < this.recipe.height; ++y) {
                String s = (String)shape.get(y);
                for (int x = 0; x < this.recipe.width; ++x) {
                    if (x < s.length()) {
                        input.add(map.get(Character.valueOf(s.charAt(x))));
                        continue;
                    }
                    input.add(null);
                }
            }
            this.recipe.input = input.toArray(new IRecipeObject[input.size()]);
            return this;
        }

        public Builder mirrored(boolean mirrored) {
            this.recipe.mirrored = mirrored;
            return this;
        }

        public RecipeCharset build() {
            return this.recipe;
        }
    }
}

