/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.blocks;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.lib.blocks.TileBase;

public abstract class BlockBase
extends Block {
    protected final Map<IBlockAccess, TileEntity> lastBrokenMap = new HashMap<IBlockAccess, TileEntity>();
    private boolean isTileProvider = this instanceof ITileEntityProvider;

    public BlockBase(Material materialIn) {
        super(materialIn);
    }

    protected TileEntity getTileAfterBreak(IBlockAccess world, BlockPos pos) {
        TileEntity lastBroken;
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null && (lastBroken = this.lastBrokenMap.get(world)) != null && lastBroken.func_174877_v().equals((Object)pos)) {
            tile = lastBroken;
        }
        return tile;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (this.isTileProvider && (tile = worldIn.func_175625_s(pos)) instanceof TileBase) {
            this.lastBrokenMap.put((IBlockAccess)worldIn, tile);
            ((TileBase)tile).dropContents();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        if (this.isTileProvider && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            return ((TileBase)tile).getPickedBlock();
        }
        return new ItemStack((Block)this);
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile;
        if (this.isTileProvider && (tile = worldIn.func_175625_s(pos)) instanceof TileBase) {
            return ((TileBase)tile).getComparatorValue();
        }
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (this.isTileProvider && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            ((TileBase)tile).onPlacedBy(placer, stack);
        }
    }
}

