/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.api.audio;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import pl.asie.charset.api.audio.AudioAPI;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioSink;

public final class AudioPacket {
    protected Set<AudioSink> sinks = new HashSet<AudioSink>();
    protected AudioData data;
    protected float volume;

    public AudioPacket(AudioPacket parent) {
        this(parent.getData(), parent.getVolume());
    }

    public AudioPacket(AudioData data, float volume) {
        this.data = data;
        this.volume = volume;
    }

    public AudioPacket() {
    }

    public void send() {
        this.data.sendClient(this);
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean add(@Nonnull AudioSink sink) {
        return this.sinks.add(sink);
    }

    public boolean addAll(@Nonnull Collection<AudioSink> sinks) {
        return sinks.addAll(sinks);
    }

    public AudioData getData() {
        return this.data;
    }

    public Set<AudioSink> getSinks() {
        return ImmutableSet.copyOf(this.sinks);
    }

    public int getSinkCount() {
        return this.sinks.size();
    }

    public void writeData(ByteBuf buffer) {
        buffer.writeFloat(this.volume);
        buffer.writeShort(AudioAPI.DATA_REGISTRY.getId(this.data.getClass()));
        this.data.writeData(buffer);
        buffer.writeShort(this.sinks.size());
        for (AudioSink sink : this.sinks) {
            sink.writeData(buffer);
        }
    }

    public void readData(ByteBuf buffer) {
        this.volume = buffer.readFloat();
        this.data = AudioAPI.DATA_REGISTRY.create(buffer.readUnsignedShort());
        this.data.readData(buffer);
        int sinkLen = buffer.readUnsignedShort();
        this.sinks.clear();
        for (int i = 0; i < sinkLen; ++i) {
            this.sinks.add(AudioSink.create(buffer));
        }
    }
}

