/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import net.minecraft.util.EnumParticleTypes;

public class DragonParticleHelper
extends DragonHelper {
    public DragonParticleHelper(EntityTameableDragon dragon) {
        super(dragon);
    }

    public void spawnBodyParticle(EnumParticleTypes type) {
        double oz;
        double oy;
        double ox;
        float s = this.dragon.getScale() * 1.2f;
        switch (type) {
            case EXPLOSION_NORMAL: {
                ox = this.rand.nextGaussian() * (double)s;
                oy = this.rand.nextGaussian() * (double)s;
                oz = this.rand.nextGaussian() * (double)s;
                break;
            }
            case CLOUD: {
                ox = (this.rand.nextDouble() - 0.5) * 0.1;
                oy = this.rand.nextDouble() * 0.2;
                oz = (this.rand.nextDouble() - 0.5) * 0.1;
                break;
            }
            case REDSTONE: {
                ox = 0.8;
                oy = 0.0;
                oz = 0.8;
                break;
            }
            default: {
                ox = 0.0;
                oy = 0.0;
                oz = 0.0;
            }
        }
        double x = this.dragon.field_70165_t + (this.rand.nextDouble() - 0.5) * (double)this.dragon.field_70130_N * (double)s;
        double y = this.dragon.field_70163_u + (this.rand.nextDouble() - 0.5) * (double)this.dragon.field_70131_O * (double)s;
        double z = this.dragon.field_70161_v + (this.rand.nextDouble() - 0.5) * (double)this.dragon.field_70130_N * (double)s;
        this.dragon.field_70170_p.func_175688_a(type, x, y, z, ox, oy, oz, new int[0]);
    }

    public void spawnBodyParticles(EnumParticleTypes type, int baseAmount) {
        int amount = (int)((float)baseAmount * this.dragon.getScale());
        for (int i = 0; i < amount; ++i) {
            this.spawnBodyParticle(type);
        }
    }

    public void spawnBodyParticles(EnumParticleTypes type) {
        this.spawnBodyParticles(type, 32);
    }

    @Override
    public void onDeathUpdate() {
        if (this.dragon.isClient() && !this.dragon.isEgg() && this.dragon.field_70725_aQ < this.dragon.getMaxDeathTime() - 20) {
            this.spawnBodyParticles(EnumParticleTypes.CLOUD, 4);
        }
    }
}

