/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.cmd;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;

public interface IDragonModifier {
    public static final double MODIFIER_RANGE = 64.0;

    default public void applyModifier(MinecraftServer server, ICommandSender sender, Consumer<EntityTameableDragon> modifier) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
            AxisAlignedBB aabb = player.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0);
            List dragons = player.field_70170_p.func_72872_a(EntityTameableDragon.class, aabb);
            Optional closestDragon = dragons.stream().max((dragon1, dragon2) -> Float.compare(dragon1.func_70032_d((Entity)player), dragon2.func_70032_d((Entity)player)));
            if (!closestDragon.isPresent()) {
                throw new CommandException("commands.dragon.nodragons", new Object[0]);
            }
            modifier.accept((EntityTameableDragon)((Object)closestDragon.get()));
        } else {
            for (WorldServer worldServer : server.field_71305_c) {
                List<EntityTameableDragon> dragons = worldServer.field_72996_f.stream().filter(entity -> entity instanceof EntityTameableDragon).map(entity -> (EntityTameableDragon)((Object)entity)).collect(Collectors.toList());
                dragons.forEach(modifier);
            }
        }
    }
}

