/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.foamfix.util.MethodHandleHelper;

public class FoamyItemLayerModel
implements IRetexturableModel {
    private static final ResourceLocation MISSINGNO = new ResourceLocation("missingno");
    private static final MethodHandle OVERRIDES_GET;
    private static final MethodHandle BUILD_QUAD;
    private final ItemLayerModel parent;

    public FoamyItemLayerModel(ItemLayerModel parent) {
        this.parent = parent;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return new FoamyItemLayerModel(this.parent.retexture(textures));
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.parent.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.parent.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return FoamyItemLayerModel.bake(this.parent, state, format, bakedTextureGetter);
    }

    public static IBakedModel bake(ItemLayerModel parent, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ItemOverrideList list;
        TextureAtlasSprite sprite;
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional transform = state.apply(Optional.absent());
        List textures = (List)parent.getTextures();
        ImmutableList.Builder textureAtlas = new ImmutableList.Builder();
        if (BUILD_QUAD != null) {
            for (i = 0; i < textures.size(); ++i) {
                sprite = (TextureAtlasSprite)bakedTextureGetter.apply(textures.get(i));
                textureAtlas.add((Object)sprite);
                try {
                    builder.add((Object)BUILD_QUAD.invokeExact(format, transform, EnumFacing.SOUTH, sprite, i, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        } else {
            for (i = 0; i < textures.size(); ++i) {
                sprite = (TextureAtlasSprite)bakedTextureGetter.apply(textures.get(i));
                for (BakedQuad quad : ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)sprite, (VertexFormat)format, (Optional)transform)) {
                    if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                    builder.add((Object)quad);
                }
            }
        }
        TextureAtlasSprite particle = (TextureAtlasSprite)bakedTextureGetter.apply((Object)(textures.isEmpty() ? MISSINGNO : (ResourceLocation)textures.get(0)));
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        try {
            list = OVERRIDES_GET.invokeExact(parent);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return new DynamicItemModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, list, (List<TextureAtlasSprite>)textureAtlas.build(), format, (Optional<TRSRTransformation>)transform).otherModel;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    static {
        MethodHandle handle = null;
        try {
            handle = MethodHandles.lookup().unreflect(ReflectionHelper.findMethod(ItemLayerModel.class, null, (String[])new String[]{"buildQuad"}, (Class[])new Class[]{VertexFormat.class, Optional.class, EnumFacing.class, TextureAtlasSprite.class, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BUILD_QUAD = handle;
        handle = null;
        try {
            handle = MethodHandleHelper.findFieldGetter(ItemLayerModel.class, "overrides");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OVERRIDES_GET = handle;
    }

    public static class DynamicItemModel
    implements IPerspectiveAwareModel {
        private final List<TextureAtlasSprite> textures;
        private final TextureAtlasSprite particle;
        private final ImmutableList<BakedQuad> fastQuads;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final VertexFormat format;
        private final Optional<TRSRTransformation> transform;
        private final IBakedModel otherModel;
        private final ItemOverrideList overrides;

        public DynamicItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList overrides, List<TextureAtlasSprite> textures, VertexFormat format, Optional<TRSRTransformation> transform) {
            this.fastQuads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            this.textures = textures;
            this.format = format;
            this.transform = transform;
            this.otherModel = new Dynamic3DItemModel(this);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return side == null ? this.fastQuads : Collections.EMPTY_LIST;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
            if (type != ItemCameraTransforms.TransformType.GUI) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }
    }

    public static class Dynamic3DItemModel
    implements IPerspectiveAwareModel {
        private final DynamicItemModel parent;
        private SoftReference<List<BakedQuad>> quadsSoft = null;

        public Dynamic3DItemModel(DynamicItemModel parent) {
            this.parent = parent;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)this.parent.transforms, (ItemCameraTransforms.TransformType)type);
            if (type == ItemCameraTransforms.TransformType.GUI && pair.getRight() == null) {
                return Pair.of((Object)this.parent, null);
            }
            return pair;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (this.quadsSoft == null || this.quadsSoft.get() == null) {
                ImmutableList.Builder builder = new ImmutableList.Builder();
                for (int i = 0; i < this.parent.textures.size(); ++i) {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)this.parent.textures.get(i);
                    builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)sprite, (VertexFormat)this.parent.format, (Optional)this.parent.transform));
                }
                this.quadsSoft = new SoftReference<ImmutableList>(builder.build());
            }
            return side == null ? this.quadsSoft.get() : Collections.EMPTY_LIST;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return this.parent.overrides;
        }
    }
}

